/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.helix.zookeeper.zkclient.ExceptionUtil;
import org.apache.helix.zookeeper.zkclient.IZkConnection;
import org.apache.helix.zookeeper.zkclient.exception.ZkException;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkConnection
implements IZkConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZkConnection.class);
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private static final boolean GETCHILDREN_PAGINATION_DISABLED = Boolean.getBoolean("zk.getChildren.pagination.disabled");
    @VisibleForTesting
    protected ZooKeeper _zk = null;
    private Lock _zookeeperLock = new ReentrantLock();
    private Method _getChildrenMethod;
    private final String _servers;
    private final int _sessionTimeOut;

    public ZkConnection(String zkServers) {
        this(zkServers, 30000);
    }

    public ZkConnection(String zkServers, int sessionTimeOut) {
        this._servers = zkServers;
        this._sessionTimeOut = sessionTimeOut;
    }

    @Override
    public void connect(Watcher watcher) {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            try {
                LOG.debug("Creating new ZookKeeper instance to connect to " + this._servers + ".");
                this._zk = new ZooKeeper(this._servers, this._sessionTimeOut, watcher);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    @Override
    public void close() throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk != null) {
                LOG.debug("Closing ZooKeeper connected to " + this._servers);
                this._zk.close();
                this._zk = null;
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnect(Watcher watcher) throws InterruptedException {
        this._zookeeperLock.lock();
        try {
            if (this._zk == null) {
                throw new IllegalStateException("zk client has not been connected or already been closed");
            }
            ZooKeeper prevZk = this._zk;
            try {
                LOG.debug("Creating new ZookKeeper instance to reconnect to " + this._servers + ".");
                this._zk = new ZooKeeper(this._servers, this._sessionTimeOut, watcher);
                prevZk.close();
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this._servers, e);
            }
        }
        finally {
            this._zookeeperLock.unlock();
        }
    }

    @Override
    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, acl, mode);
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode mode, long ttl) throws KeeperException, InterruptedException {
        return this._zk.create(path, data, acl, mode, null, ttl);
    }

    @Override
    public void delete(String path) throws InterruptedException, KeeperException {
        this._zk.delete(path, -1);
    }

    @Override
    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.exists(path, watch) != null;
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        if (this._getChildrenMethod == null) {
            this.lookupGetChildrenMethod();
        }
        try {
            List children = (List)this._getChildrenMethod.invoke((Object)this._zk, path, watch);
            return children;
        }
        catch (InvocationTargetException e) {
            this.handleInvokedMethodException(e.getCause());
        }
        catch (IllegalAccessException e) {
            LOG.error("Unable to get children for {}", (Object)path, (Object)e);
        }
        throw KeeperException.create((KeeperException.Code)KeeperException.Code.APIERROR, (String)path);
    }

    @Override
    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        return this._zk.getData(path, watch, stat);
    }

    public void writeData(String path, byte[] data) throws KeeperException, InterruptedException {
        this.writeData(path, data, -1);
    }

    @Override
    public void writeData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        this._zk.setData(path, data, version);
    }

    @Override
    public Stat writeDataReturnStat(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this._zk.setData(path, data, version);
    }

    @Override
    public ZooKeeper.States getZookeeperState() {
        return this._zk != null ? this._zk.getState() : null;
    }

    public ZooKeeper getZookeeper() {
        return this._zk;
    }

    @Override
    public long getCreateTime(String path) throws KeeperException, InterruptedException {
        Stat stat = this._zk.exists(path, false);
        if (stat != null) {
            return stat.getCtime();
        }
        return -1L;
    }

    @Override
    public String getServers() {
        return this._servers;
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) throws KeeperException, InterruptedException {
        return this._zk.multi(ops);
    }

    @Override
    public void addAuthInfo(String scheme, byte[] auth) {
        this._zk.addAuthInfo(scheme, auth);
    }

    @Override
    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode) throws KeeperException, InterruptedException {
        this._zk.addWatch(basePath, watcher, mode);
    }

    @Override
    public void removeWatches(String path, Watcher watcher, Watcher.WatcherType watcherType) throws InterruptedException, KeeperException {
        this._zk.removeWatches(path, watcher, watcherType, true);
    }

    private void lookupGetChildrenMethod() {
        this._getChildrenMethod = this.doLookUpGetChildrenMethod();
        LOG.info("Pagination config {}={}, method to be invoked: {}", new Object[]{"zk.getChildren.pagination.disabled", GETCHILDREN_PAGINATION_DISABLED, this._getChildrenMethod.getName()});
    }

    private Method doLookUpGetChildrenMethod() {
        if (!GETCHILDREN_PAGINATION_DISABLED) {
            try {
                return ZooKeeper.class.getMethod("getAllChildrenPaginated", String.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                LOG.info("Paginated getChildren is not supported, fall back to non-paginated getChildren");
            }
        }
        return this.lookupNonPaginatedGetChildren();
    }

    private Method lookupNonPaginatedGetChildren() {
        try {
            return ZooKeeper.class.getMethod("getChildren", String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionUtil.convertToRuntimeException(e.getCause());
        }
    }

    private void handleInvokedMethodException(Throwable cause) throws KeeperException, InterruptedException {
        if (cause instanceof KeeperException.UnimplementedException) {
            LOG.warn("Paginated getChildren is unimplemented in ZK server! Falling back to non-paginated getChildren");
            this._getChildrenMethod = this.lookupNonPaginatedGetChildren();
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS);
        }
        if (cause instanceof KeeperException) {
            throw KeeperException.create((KeeperException.Code)((KeeperException)cause).code());
        }
        if (cause instanceof InterruptedException) {
            throw new InterruptedException(cause.getMessage());
        }
        throw ExceptionUtil.convertToRuntimeException(cause);
    }
}

