/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.CurrentStateSnapshot;
import org.apache.helix.common.caches.ParticipantStateCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateCache
extends ParticipantStateCache<CurrentState> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CurrentStateCache.class.getName());
    private boolean _initialized = false;
    private CurrentStateSnapshot _snapshot = new CurrentStateSnapshot(this._participantStateCache);

    public CurrentStateCache(String clusterName) {
        this(CurrentStateCache.createDefaultControlContextProvider(clusterName));
    }

    public CurrentStateCache(ControlContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected Set<PropertyKey> PopulateParticipantKeys(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        HashSet<PropertyKey> participantStateKeys = new HashSet<PropertyKey>();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String instanceName : liveInstanceMap.keySet()) {
            LiveInstance liveInstance = liveInstanceMap.get(instanceName);
            String sessionId = liveInstance.getEphemeralOwner();
            List<String> currentStateNames = accessor.getChildNames(keyBuilder.currentStates(instanceName, sessionId));
            for (String currentStateName : currentStateNames) {
                participantStateKeys.add(keyBuilder.currentState(instanceName, sessionId, currentStateName));
            }
        }
        return participantStateKeys;
    }

    @Override
    protected void refreshSnapshot(Map<PropertyKey, CurrentState> newStateCache, Map<PropertyKey, CurrentState> participantStateCache, Set<PropertyKey> reloadedKeys) {
        if (this._initialized) {
            this._snapshot = new CurrentStateSnapshot(newStateCache, participantStateCache, reloadedKeys);
        } else {
            this._snapshot = new CurrentStateSnapshot(newStateCache);
            this._initialized = true;
        }
    }

    @Override
    public CurrentStateSnapshot getSnapshot() {
        return this._snapshot;
    }
}

