/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.agent;

import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.agent.CommandAttribute;

public class CommandConfig {
    private final String _fromState;
    private final String _toState;
    private final String _command;
    private final String _workingDir;
    private final String _timeout;
    private final String _pidFile;

    public CommandConfig(String fromState, String toState, String command, String workingDir, String timeout, String pidFile) {
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        this._fromState = fromState;
        this._toState = toState;
        this._command = command;
        this._workingDir = workingDir;
        this._timeout = timeout;
        this._pidFile = pidFile;
    }

    private String buildKey(String fromState, String toState, CommandAttribute attribute) {
        return fromState + "-" + toState + "." + attribute.getName();
    }

    public Map<String, String> toKeyValueMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(this.buildKey(this._fromState, this._toState, CommandAttribute.COMMAND), this._command);
        if (!this._command.equals(CommandAttribute.NOP.getName())) {
            if (this._workingDir != null) {
                map.put(this.buildKey(this._fromState, this._toState, CommandAttribute.WORKING_DIR), this._workingDir);
            }
            if (this._timeout != null) {
                map.put(this.buildKey(this._fromState, this._toState, CommandAttribute.TIMEOUT), this._timeout);
            }
            if (this._pidFile != null) {
                map.put(this.buildKey(this._fromState, this._toState, CommandAttribute.PID_FILE), this._pidFile);
            }
        }
        return map;
    }

    public static class Builder {
        private String _fromState;
        private String _toState;
        private String _command;
        private String _workingDir;
        private String _timeout;
        private String _pidFile;

        public Builder setTransition(String fromState, String toState) {
            this._fromState = fromState;
            this._toState = toState;
            return this;
        }

        public Builder setCommand(String command) {
            this._command = command;
            return this;
        }

        public Builder setCommandWorkingDir(String workingDir) {
            this._workingDir = workingDir;
            return this;
        }

        public Builder setCommandTimeout(String timeout) {
            this._timeout = timeout;
            return this;
        }

        public Builder setPidFile(String pidFile) {
            this._pidFile = pidFile;
            return this;
        }

        public CommandConfig build() {
            return new CommandConfig(this._fromState, this._toState, this._command, this._workingDir, this._timeout, this._pidFile);
        }
    }
}

