/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.metrics.implementation;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.concurrent.TimeUnit;
import org.apache.helix.monitoring.metrics.model.LatencyMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalanceLatencyGauge
extends LatencyMetric {
    private static final Logger LOG = LoggerFactory.getLogger(RebalanceLatencyGauge.class);
    private static final long VALUE_NOT_SET = -1L;
    private long _lastEmittedMetricValue = -1L;
    private final ThreadLocal<Long> _startTime;

    public RebalanceLatencyGauge(String metricName, long slidingTimeWindow) {
        super(metricName, new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(slidingTimeWindow, TimeUnit.MILLISECONDS)));
        this._metricName = metricName;
        this._startTime = ThreadLocal.withInitial(() -> -1L);
    }

    @Override
    public void startMeasuringLatency() {
        this.reset();
        this._startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endMeasuringLatency() {
        if (this._startTime.get() == -1L) {
            LOG.error("Needs to call startMeasuringLatency first! Ignoring and resetting the metric. Metric name: {}", (Object)this._metricName);
            return;
        }
        RebalanceLatencyGauge rebalanceLatencyGauge = this;
        synchronized (rebalanceLatencyGauge) {
            this._lastEmittedMetricValue = System.currentTimeMillis() - this._startTime.get();
            this.updateValue(this._lastEmittedMetricValue);
        }
        this.reset();
    }

    @Override
    public Long getLastEmittedMetricValue() {
        return this._lastEmittedMetricValue;
    }

    private void reset() {
        this._startTime.set(-1L);
    }
}

