/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;

public class IndexRowComparatorImpl
implements IndexRowComparator {
    protected final IndexKeyTypeSettings keyTypeSettings;

    public IndexRowComparatorImpl(IndexKeyTypeSettings settings) {
        this.keyTypeSettings = settings;
    }

    @Override
    public int compareKey(long pageAddr, int off, int maxSize, IndexKey key, InlineIndexKeyType type) {
        IndexKeyType inlineKeyType = type.type();
        if (inlineKeyType == IndexKeyType.UNKNOWN) {
            return -2;
        }
        if (inlineKeyType == key.type() || this.isInlineComparable(type, key)) {
            if (inlineKeyType != IndexKeyType.JAVA_OBJECT || this.keyTypeSettings.inlineObjSupported()) {
                return type.compare(pageAddr, off, maxSize, key);
            }
            return -2;
        }
        return Integer.MIN_VALUE;
    }

    private boolean isInlineComparable(InlineIndexKeyType type, IndexKey key) {
        if (key == NullIndexKey.INSTANCE) {
            return true;
        }
        return type.isComparableTo(key);
    }

    @Override
    public int compareRow(IndexRow left, IndexRow right, int idx) throws IgniteCheckedException {
        return this.compare(left.key(idx), right.key(idx));
    }

    @Override
    public int compareKey(IndexKey left, IndexKey right) throws IgniteCheckedException {
        if (left == right) {
            return 0;
        }
        return this.compare(left, right);
    }

    private int compare(IndexKey lkey, IndexKey rkey) throws IgniteCheckedException {
        try {
            if (lkey == NullIndexKey.INSTANCE) {
                return lkey.compare(rkey);
            }
            if (rkey == NullIndexKey.INSTANCE) {
                return 1;
            }
            if (lkey.type() == rkey.type() || lkey.isComparableTo(rkey)) {
                return lkey.compare(rkey);
            }
            if (rkey.isComparableTo(lkey)) {
                return -rkey.compare(lkey);
            }
        }
        catch (RuntimeException e) {
            throw new IgniteCheckedException(e);
        }
        throw new IgniteCheckedException("Values can't be compared [lkey=" + lkey + ", rkey=" + rkey + "]");
    }
}

