/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Async;

public class NettyUtils {
    public static <T, R, F extends Future<R>> CompletableFuture<T> toCompletableFuture(@Async.Schedule F nettyFuture, Function<F, T> mapper) {
        return NettyUtils.toCompletableFuture(nettyFuture, mapper, CompletableFuture::new);
    }

    public static <T, R, F extends Future<R>> CompletableFuture<T> toCompletableFuture(@Async.Schedule F nettyFuture, Function<F, T> mapper, Supplier<? extends CompletableFuture<T>> completableFutureFactory) {
        CompletableFuture completableFuture = completableFutureFactory.get();
        nettyFuture.addListener(doneFuture -> {
            if (doneFuture.isSuccess()) {
                completableFuture.complete(mapper.apply(doneFuture));
            } else if (doneFuture.isCancelled()) {
                completableFuture.cancel(true);
            } else {
                completableFuture.completeExceptionally(doneFuture.cause());
            }
        });
        return completableFuture;
    }

    public static <T> CompletableFuture<T> toCompletableFuture(Future<T> future) {
        return NettyUtils.toCompletableFuture(future, fut -> null);
    }

    public static CompletableFuture<Channel> toChannelCompletableFuture(ChannelFuture channelFuture) {
        return NettyUtils.toCompletableFuture(channelFuture, ChannelFuture::channel, CompletableFuture::new);
    }
}

