/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.model;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ModelHyperparameter {
    private final Map<String, String> keyValueMap;

    public ModelHyperparameter(Map<String, String> keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    public void update(Map<String, String> modelInfo) {
        this.keyValueMap.putAll(modelInfo);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> keyValuePair : this.keyValueMap.entrySet()) {
            stringBuilder.append(keyValuePair.getKey()).append('=').append(keyValuePair.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public List<String> toStringList() {
        ArrayList<String> resultList = new ArrayList<String>();
        for (Map.Entry<String, String> keyValuePair : this.keyValueMap.entrySet()) {
            resultList.add(keyValuePair.getKey() + "=" + keyValuePair.getValue());
        }
        return resultList;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.keyValueMap, (OutputStream)stream);
    }

    public void serialize(FileOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.keyValueMap, (OutputStream)stream);
    }

    public static ModelHyperparameter deserialize(ByteBuffer buffer) {
        return new ModelHyperparameter(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
    }

    public static ModelHyperparameter deserialize(InputStream stream) throws IOException {
        return new ModelHyperparameter(ReadWriteIOUtils.readMap((InputStream)stream));
    }
}

