/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.chunk.ChunkReader;

public class SharedTimeDataBuffer {
    private ByteBuffer timeBuffer;
    private final IChunkMetadata timeChunkMetaData;
    private ChunkHeader timeChunkHeader;
    private final List<long[]> timeData;
    private final Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    private EncryptParameter encryptParam;

    public SharedTimeDataBuffer(IChunkMetadata timeChunkMetaData) {
        this.timeChunkMetaData = timeChunkMetaData;
        this.timeData = new ArrayList<long[]>();
    }

    public void init(TsFileSequenceReader reader) throws IOException {
        if (this.timeBuffer != null) {
            return;
        }
        Chunk timeChunk = reader.readMemChunk(this.timeChunkMetaData.getOffsetOfChunkHeader());
        this.timeChunkHeader = timeChunk.getHeader();
        this.timeBuffer = timeChunk.getData();
        this.encryptParam = timeChunk.getEncryptParam();
    }

    public long[] getPageTime(int pageId) throws IOException {
        int size = this.timeData.size();
        if (pageId < size) {
            return this.timeData.get(pageId);
        }
        if (pageId == size) {
            this.loadPageData();
            return this.timeData.get(pageId);
        }
        throw new UnsupportedOperationException("PageId in SharedTimeDataBuffer should be  incremental.");
    }

    private void loadPageData() throws IOException {
        if (!this.timeBuffer.hasRemaining()) {
            throw new UnsupportedOperationException("No more data in SharedTimeDataBuffer");
        }
        PageHeader timePageHeader = this.isSinglePageChunk() ? PageHeader.deserializeFrom((ByteBuffer)this.timeBuffer, (Statistics)this.timeChunkMetaData.getStatistics()) : PageHeader.deserializeFrom((ByteBuffer)this.timeBuffer, (TSDataType)this.timeChunkHeader.getDataType());
        IDecryptor decryptor = IDecryptor.getDecryptor((EncryptParameter)this.encryptParam);
        ByteBuffer timePageData = ChunkReader.deserializePageData((PageHeader)timePageHeader, (ByteBuffer)this.timeBuffer, (ChunkHeader)this.timeChunkHeader, (IDecryptor)decryptor);
        long[] pageData = new long[(int)timePageHeader.getNumOfValues()];
        int index = 0;
        while (this.defaultTimeDecoder.hasNext(timePageData)) {
            pageData[index++] = this.defaultTimeDecoder.readLong(timePageData);
        }
        this.timeData.add(pageData);
    }

    private boolean isSinglePageChunk() {
        return (this.timeChunkHeader.getChunkType() & 0x3F) == 5;
    }
}

