/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.value.ValueHelper;

class RemoveMixinOperation
implements SessionWriteOperation<Object> {
    private final NodeImpl node;
    private final Name mixinName;

    public RemoveMixinOperation(NodeImpl node, Name mixinName) {
        this.node = node;
        this.mixinName = mixinName;
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        ItemDefinition oldDef;
        EffectiveNodeType entResulting;
        SessionImpl session = context.getSessionImpl();
        ItemManager itemMgr = context.getItemManager();
        SessionItemStateManager stateMgr = context.getItemStateManager();
        context.getItemValidator().checkModify(this.node, 150, 128);
        NodeState state = this.node.getNodeState();
        if (!state.getMixinTypeNames().contains(this.mixinName)) {
            throw new NoSuchNodeTypeException("Mixin " + context.getJCRName(this.mixinName) + " not included in " + String.valueOf(this.node));
        }
        NodeTypeManagerImpl ntMgr = context.getNodeTypeManager();
        NodeTypeRegistry ntReg = context.getNodeTypeRegistry();
        HashSet<Name> remainingMixins = new HashSet<Name>(state.getMixinTypeNames());
        remainingMixins.remove(this.mixinName);
        try {
            entResulting = ntReg.getEffectiveNodeType(state.getNodeTypeName(), remainingMixins);
        }
        catch (NodeTypeConflictException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        NodeTypeImpl mixin = ntMgr.getNodeType(this.mixinName);
        if (this.isReferenceable(mixin) && !entResulting.includesNodeType(NameConstants.MIX_REFERENCEABLE) && this.node.getReferences().hasNext()) {
            throw new ConstraintViolationException(String.valueOf(this.mixinName) + " can not be removed: the node is being referenced through at least one property of type REFERENCE");
        }
        if ((NameConstants.MIX_LOCKABLE.equals(this.mixinName) || mixin.isDerivedFrom(NameConstants.MIX_LOCKABLE)) && !entResulting.includesNodeType(NameConstants.MIX_LOCKABLE) && this.node.isLocked()) {
            throw new ConstraintViolationException(String.valueOf(this.mixinName) + " can not be removed: the node is locked.");
        }
        NodeState thisState = (NodeState)this.node.getOrCreateTransientItemState();
        HashMap<PropertyId, ItemDefinitionImpl> affectedProps = new HashMap<PropertyId, ItemDefinitionImpl>();
        HashMap<ChildNodeEntry, ItemDefinitionImpl> affectedNodes = new HashMap<ChildNodeEntry, ItemDefinitionImpl>();
        try {
            NodeTypeImpl declaringNT;
            Set<Name> names = thisState.getPropertyNames();
            for (Name name : names) {
                PropertyId propId = new PropertyId(thisState.getNodeId(), name);
                PropertyState propState = (PropertyState)stateMgr.getItemState(propId);
                oldDef = itemMgr.getDefinition(propState);
                declaringNT = (NodeTypeImpl)oldDef.getDeclaringNodeType();
                if (entResulting.includesNodeType(declaringNT.getQName())) continue;
                affectedProps.put(propId, (ItemDefinitionImpl)oldDef);
            }
            Iterator entries = thisState.getChildNodeEntries();
            Iterator<ChildNodeEntry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                ChildNodeEntry entry = iterator.next();
                NodeState nodeState = (NodeState)stateMgr.getItemState(entry.getId());
                oldDef = itemMgr.getDefinition(nodeState);
                declaringNT = (NodeTypeImpl)oldDef.getDeclaringNodeType();
                if (entResulting.includesNodeType(declaringNT.getQName())) continue;
                affectedNodes.put(entry, (ItemDefinitionImpl)oldDef);
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Failed to determine effect of removing mixin " + context.getJCRName(this.mixinName), e);
        }
        thisState.setMixinTypeNames(remainingMixins);
        this.node.setMixinTypesProperty(remainingMixins);
        boolean success = false;
        try {
            ItemDefinitionImpl newDef;
            for (Map.Entry entry : affectedProps.entrySet()) {
                PropertyId id = (PropertyId)entry.getKey();
                PropertyImpl prop = (PropertyImpl)itemMgr.getItem(id);
                oldDef = (PropertyDefinition)entry.getValue();
                if (oldDef.isProtected()) {
                    this.node.removeChildProperty(id.getName());
                    continue;
                }
                try {
                    newDef = this.node.getApplicablePropertyDefinition(id.getName(), prop.getType(), oldDef.isMultiple(), false);
                    if (((PropertyDefinitionImpl)newDef).getRequiredType() != 0 && ((PropertyDefinitionImpl)newDef).getRequiredType() != prop.getType()) {
                        if (oldDef.isMultiple()) {
                            Value[] values = ValueHelper.convert(prop.getValues(), ((PropertyDefinitionImpl)newDef).getRequiredType(), session.getValueFactory());
                            prop.onRedefine(((PropertyDefinitionImpl)newDef).unwrap());
                            prop.setValue(values);
                            continue;
                        }
                        Value value = ValueHelper.convert(prop.getValue(), ((PropertyDefinitionImpl)newDef).getRequiredType(), session.getValueFactory());
                        prop.onRedefine(((PropertyDefinitionImpl)newDef).unwrap());
                        prop.setValue(value);
                        continue;
                    }
                    prop.onRedefine(((PropertyDefinitionImpl)newDef).unwrap());
                }
                catch (ValueFormatException vfe) {
                    this.node.removeChildProperty(id.getName());
                }
                catch (ConstraintViolationException cve) {
                    this.node.removeChildProperty(id.getName());
                }
            }
            for (ChildNodeEntry childNodeEntry : affectedNodes.keySet()) {
                NodeState nodeState = (NodeState)stateMgr.getItemState(childNodeEntry.getId());
                NodeImpl childNode = (NodeImpl)itemMgr.getItem(childNodeEntry.getId());
                oldDef = (NodeDefinition)affectedNodes.get(childNodeEntry);
                if (oldDef.isProtected()) {
                    this.node.removeChildNode(childNodeEntry.getId());
                    continue;
                }
                try {
                    newDef = this.node.getApplicableChildNodeDefinition(childNodeEntry.getName(), nodeState.getNodeTypeName());
                    childNode.onRedefine(((NodeDefinitionImpl)newDef).unwrap());
                }
                catch (ConstraintViolationException cve) {
                    this.node.removeChildNode(childNodeEntry.getId());
                }
            }
            success = true;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Failed to clean up child items defined by removed mixin " + context.getJCRName(this.mixinName), e);
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
        return this;
    }

    private boolean isReferenceable(NodeTypeImpl mixin) {
        return NameConstants.MIX_REFERENCEABLE.equals(this.mixinName) || mixin.isDerivedFrom(NameConstants.MIX_REFERENCEABLE);
    }

    public String toString() {
        return "node.removeMixin(" + String.valueOf(this.mixinName) + ")";
    }
}

