/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockInfo;

class LockImpl
implements Lock {
    protected final LockInfo info;
    protected final NodeImpl node;

    public LockImpl(LockInfo info, NodeImpl node) {
        this.info = info;
        this.node = node;
    }

    @Override
    public String getLockOwner() {
        return this.info.getLockOwner();
    }

    @Override
    public boolean isDeep() {
        return this.info.isDeep();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getLockToken() {
        if (!this.info.isSessionScoped() && (this.info.isLockHolder(this.node.getSession()) || this.isAdminUser(this.node.getSession()))) {
            return this.info.getLockToken();
        }
        return null;
    }

    @Override
    public boolean isLive() throws RepositoryException {
        return this.info.isLive();
    }

    @Override
    public boolean isSessionScoped() {
        return this.info.isSessionScoped();
    }

    @Override
    public void refresh() throws LockException, RepositoryException {
        if (!this.isLive()) {
            this.info.throwLockException("Lock is not live any more", (SessionImpl)this.node.getSession());
        } else if (!this.isLockOwningSession()) {
            this.info.throwLockException("Session does not hold lock.", (SessionImpl)this.node.getSession());
        } else {
            SessionImpl session = (SessionImpl)this.node.getSession();
            session.getAccessManager().checkPermission(this.node.getPrimaryPath(), 512);
            this.info.updateTimeoutTime();
        }
    }

    @Override
    public long getSecondsRemaining() {
        if (!this.info.isLive()) {
            return -1L;
        }
        long timeout = this.info.getTimeoutTime();
        if (timeout == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long remainingSeconds = (timeout - System.currentTimeMillis()) / 1000L;
        return Math.max(remainingSeconds, 1L);
    }

    @Override
    public boolean isLockOwningSession() {
        return this.info.isLockHolder(this.node.getSession());
    }

    private boolean isAdminUser(Session session) {
        if (session instanceof SessionImpl) {
            return ((SessionImpl)session).isAdmin();
        }
        return "admin".equals(session.getUserID());
    }
}

