/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.component.plugins.Plugin;
import org.apache.log4j.component.plugins.PluginRegistry;
import org.apache.log4j.component.scheduler.Scheduler;
import org.apache.log4j.component.spi.ErrorItem;
import org.apache.log4j.component.spi.LoggerEventListener;
import org.apache.log4j.component.spi.LoggerRepositoryEventListener;
import org.apache.log4j.component.spi.LoggerRepositoryEx;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.HierarchyEventListener;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public final class LoggerRepositoryExImpl
implements LoggerRepositoryEx,
RendererSupport,
UnrecognizedElementHandler {
    private final LoggerRepository repo;
    private LoggerFactory loggerFactory;
    private final RendererSupport rendererSupport;
    private final ArrayList repositoryEventListeners = new ArrayList();
    private final Map loggerEventListeners = new HashMap();
    private String name;
    private PluginRegistry pluginRegistry;
    private final Map properties = new Hashtable();
    private Scheduler scheduler;
    private Map objectMap = new HashMap();
    private List errorList = new Vector();
    private boolean pristine = true;

    public LoggerRepositoryExImpl(LoggerRepository repository) {
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        this.repo = repository;
        this.rendererSupport = repository instanceof RendererSupport ? (RendererSupport)((Object)repository) : new RendererSupportImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoggerRepositoryEventListener(LoggerRepositoryEventListener listener) {
        ArrayList arrayList = this.repositoryEventListeners;
        synchronized (arrayList) {
            if (this.repositoryEventListeners.contains(listener)) {
                LogLog.warn("Ignoring attempt to add a previously registered LoggerRepositoryEventListener.");
            } else {
                this.repositoryEventListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoggerRepositoryEventListener(LoggerRepositoryEventListener listener) {
        ArrayList arrayList = this.repositoryEventListeners;
        synchronized (arrayList) {
            if (!this.repositoryEventListeners.contains(listener)) {
                LogLog.warn("Ignoring attempt to remove a non-registered LoggerRepositoryEventListener.");
            } else {
                this.repositoryEventListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoggerEventListener(LoggerEventListener listener) {
        Map map = this.loggerEventListeners;
        synchronized (map) {
            if (this.loggerEventListeners.get(listener) != null) {
                LogLog.warn("Ignoring attempt to add a previously registerd LoggerEventListener.");
            } else {
                HierarchyEventListenerProxy proxy = new HierarchyEventListenerProxy(listener);
                this.loggerEventListeners.put(listener, proxy);
                this.repo.addHierarchyEventListener(proxy);
            }
        }
    }

    @Override
    public void addHierarchyEventListener(HierarchyEventListener listener) {
        this.repo.addHierarchyEventListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoggerEventListener(LoggerEventListener listener) {
        Map map = this.loggerEventListeners;
        synchronized (map) {
            HierarchyEventListenerProxy proxy = (HierarchyEventListenerProxy)this.loggerEventListeners.get(listener);
            if (proxy == null) {
                LogLog.warn("Ignoring attempt to remove a non-registered LoggerEventListener.");
            } else {
                this.loggerEventListeners.remove(listener);
                proxy.disable();
            }
        }
    }

    @Override
    public void emitNoAppenderWarning(Category cat) {
        this.repo.emitNoAppenderWarning(cat);
    }

    @Override
    public Logger exists(String loggerName) {
        return this.repo.exists(loggerName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String repoName) {
        if (this.name == null) {
            this.name = repoName;
        } else if (!this.name.equals(repoName)) {
            throw new IllegalStateException("Repository [" + this.name + "] cannot be renamed as [" + repoName + "].");
        }
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void setThreshold(String levelStr) {
        this.repo.setThreshold(levelStr);
    }

    @Override
    public void setThreshold(Level l) {
        this.repo.setThreshold(l);
    }

    @Override
    public PluginRegistry getPluginRegistry() {
        if (this.pluginRegistry == null) {
            this.pluginRegistry = new PluginRegistry(this);
        }
        return this.pluginRegistry;
    }

    @Override
    public void fireAddAppenderEvent(Category logger, Appender appender) {
        this.repo.fireAddAppenderEvent(logger, appender);
    }

    @Override
    public void fireRemoveAppenderEvent(Category logger, Appender appender) {
        if (this.repo instanceof Hierarchy) {
            ((Hierarchy)this.repo).fireRemoveAppenderEvent(logger, appender);
        }
    }

    @Override
    public void fireLevelChangedEvent(Logger logger) {
    }

    @Override
    public void fireConfigurationChangedEvent() {
    }

    @Override
    public Level getThreshold() {
        return this.repo.getThreshold();
    }

    @Override
    public Logger getLogger(String loggerName) {
        return this.repo.getLogger(loggerName);
    }

    @Override
    public Logger getLogger(String loggerName, LoggerFactory factory) {
        return this.repo.getLogger(loggerName, factory);
    }

    @Override
    public Enumeration getCurrentLoggers() {
        return this.repo.getCurrentLoggers();
    }

    @Override
    public List getErrorList() {
        return this.errorList;
    }

    @Override
    public void addErrorItem(ErrorItem errorItem) {
        this.getErrorList().add(errorItem);
    }

    @Override
    public Enumeration getCurrentCategories() {
        return this.repo.getCurrentCategories();
    }

    @Override
    public RendererMap getRendererMap() {
        return this.rendererSupport.getRendererMap();
    }

    @Override
    public Logger getRootLogger() {
        return this.repo.getRootLogger();
    }

    @Override
    public boolean isDisabled(int level) {
        return this.repo.isDisabled(level);
    }

    @Override
    public void resetConfiguration() {
        this.repo.resetConfiguration();
    }

    @Override
    public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
        this.rendererSupport.setRenderer(renderedClass, renderer);
    }

    @Override
    public boolean isPristine() {
        return this.pristine;
    }

    @Override
    public void setPristine(boolean state) {
        this.pristine = state;
    }

    @Override
    public void shutdown() {
        this.repo.shutdown();
    }

    @Override
    public Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            this.scheduler.setDaemon(true);
            this.scheduler.start();
        }
        return this.scheduler;
    }

    @Override
    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    @Override
    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    @Override
    public void setLoggerFactory(LoggerFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.loggerFactory = factory;
    }

    @Override
    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        Object instance;
        if ("plugin".equals(element.getNodeName()) && (instance = DOMConfigurator.parseElement(element, props, Plugin.class)) instanceof Plugin) {
            Plugin plugin = (Plugin)instance;
            String pluginName = DOMConfigurator.subst(element.getAttribute("name"), props);
            if (pluginName.length() > 0) {
                plugin.setName(pluginName);
            }
            this.getPluginRegistry().addPlugin(plugin);
            plugin.setLoggerRepository(this);
            LogLog.debug("Pushing plugin on to the object stack.");
            plugin.activateOptions();
            return true;
        }
        return false;
    }

    private static final class HierarchyEventListenerProxy
    implements HierarchyEventListener {
        private LoggerEventListener listener;

        public HierarchyEventListenerProxy(LoggerEventListener l) {
            if (l == null) {
                throw new NullPointerException("l");
            }
            this.listener = l;
        }

        @Override
        public void addAppenderEvent(Category cat, Appender appender) {
            if (this.isEnabled() && cat instanceof Logger) {
                this.listener.appenderAddedEvent((Logger)cat, appender);
            }
        }

        @Override
        public void removeAppenderEvent(Category cat, Appender appender) {
            if (this.isEnabled() && cat instanceof Logger) {
                this.listener.appenderRemovedEvent((Logger)cat, appender);
            }
        }

        public synchronized void disable() {
            this.listener = null;
        }

        private synchronized boolean isEnabled() {
            return this.listener != null;
        }
    }

    private static final class RendererSupportImpl
    implements RendererSupport {
        private final RendererMap renderers = new RendererMap();

        @Override
        public RendererMap getRendererMap() {
            return this.renderers;
        }

        @Override
        public void setRenderer(Class renderedClass, ObjectRenderer renderer) {
            this.renderers.put(renderedClass, renderer);
        }
    }
}

