/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.util.repository;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.LocalArtifactRegistration;
import shaded.org.eclipse.aether.repository.LocalArtifactRequest;
import shaded.org.eclipse.aether.repository.LocalArtifactResult;
import shaded.org.eclipse.aether.repository.LocalMetadataRegistration;
import shaded.org.eclipse.aether.repository.LocalMetadataRequest;
import shaded.org.eclipse.aether.repository.LocalMetadataResult;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.RemoteRepository;

public final class ChainedLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepositoryManager head;
    private final List<LocalRepositoryManager> tail;
    private final boolean ignoreTailAvailability;

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, boolean ignoreTailAvailability) {
        this.head = Objects.requireNonNull(head, "head cannot be null");
        this.tail = Objects.requireNonNull(tail, "tail cannot be null");
        this.ignoreTailAvailability = ignoreTailAvailability;
    }

    @Override
    public LocalRepository getRepository() {
        return this.head.getRepository();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.head.getPathForLocalArtifact(artifact);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.head.getPathForRemoteArtifact(artifact, repository, context);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.head.getPathForLocalMetadata(metadata);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.head.getPathForRemoteMetadata(metadata, repository, context);
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        LocalArtifactResult result = this.head.find(session, request);
        if (result.isAvailable()) {
            return result;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result = lrm.find(session, request);
            if (result.getFile() == null) continue;
            if (this.ignoreTailAvailability) {
                result.setAvailable(true);
                return result;
            }
            if (!result.isAvailable()) continue;
            return result;
        }
        return new LocalArtifactResult(request);
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        String artifactPath = request.getRepository() != null ? this.getPathForRemoteArtifact(request.getArtifact(), request.getRepository(), "check") : this.getPathForLocalArtifact(request.getArtifact());
        Path file = new File(this.head.getRepository().getBasedir(), artifactPath).toPath();
        if (Files.isRegularFile(file, new LinkOption[0])) {
            this.head.add(session, request);
        }
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = this.head.find(session, request);
        if (result.getFile() != null) {
            return result;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result = lrm.find(session, request);
            if (result.getFile() == null) continue;
            return result;
        }
        return new LocalMetadataResult(request);
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        String metadataPath = request.getRepository() != null ? this.getPathForRemoteMetadata(request.getMetadata(), request.getRepository(), "check") : this.getPathForLocalMetadata(request.getMetadata());
        Path file = new File(this.head.getRepository().getBasedir(), metadataPath).toPath();
        if (Files.isRegularFile(file, new LinkOption[0])) {
            this.head.add(session, request);
        }
    }

    public String toString() {
        return this.head.getRepository().toString() + this.tail.stream().map(LocalRepositoryManager::getRepository).collect(Collectors.toList());
    }
}

