/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.system.SystemService;

@Command(scope="system", name="shutdown", description="Shutdown the Karaf container.")
@Service
public class Shutdown
implements Action {
    @Option(name="-f", aliases={"--force"}, description="Force the shutdown without confirmation message.", required=false, multiValued=false)
    boolean force = false;
    @Option(name="-r", aliases={"--reboot"}, description="Reboot the Karaf container.", required=false, multiValued=false)
    boolean reboot = false;
    @Option(name="-h", aliases={"--halt"}, description="Halt the Karaf container.", required=false, multiValued=false)
    boolean halt = false;
    @Option(name="-c", aliases={"--clean", "--clean-all", "-ca"}, description="Force a clean restart by deleting the data directory")
    private boolean cleanAll;
    @Option(name="-cc", aliases={"--clean-cache", "-cc"}, description="Force a clean restart by deleting the cache directory")
    private boolean cleanCache;
    @Argument(name="time", index=0, description="Shutdown after a specified delay. The time argument can have different formats. First, it can be an absolute time in the format hh:mm, in which hh is the hour (1 or 2 digits) and mm is the minute of the hour (in two digits). Second, it can be in the format m (or +m), in which m is the number of minutes to wait. The word now is an alias for 0 (or +0).", required=false, multiValued=false)
    String time;
    @Reference
    SystemService systemService;
    @Reference
    Session session;

    public Object execute() throws Exception {
        if (this.force) {
            if (this.reboot) {
                this.systemService.reboot(this.time, this.determineSwipeType());
            } else {
                this.systemService.halt(this.time);
            }
            return null;
        }
        String karafName = System.getProperty("karaf.name");
        String msg = this.reboot ? String.format("Confirm: reboot instance %s (yes/no): ", karafName) : String.format("Confirm: halt instance %s (yes/no): ", karafName);
        String str = null;
        try {
            str = this.session.readLine(msg, null);
        }
        catch (UnsupportedOperationException e) {
            System.out.println("please use \"shutdown -f\" or \"shutdown --force\" to shutdown instance: " + karafName);
            return null;
        }
        if (str.equalsIgnoreCase("yes")) {
            if (this.reboot) {
                this.systemService.reboot(this.time, this.determineSwipeType());
            } else {
                this.systemService.halt(this.time);
            }
        }
        return null;
    }

    private SystemService.Swipe determineSwipeType() {
        if (this.cleanAll) {
            return SystemService.Swipe.ALL;
        }
        if (this.cleanCache) {
            return SystemService.Swipe.CACHE;
        }
        return SystemService.Swipe.NONE;
    }
}

