/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class PageFactory {
    public static <T> T initElements(WebDriver driver, Class<T> pageClassToProxy) {
        T page = PageFactory.instantiatePage(driver, pageClassToProxy);
        PageFactory.initElements(driver, page);
        return page;
    }

    public static void initElements(WebDriver driver, Object page) {
        WebDriver driverRef = driver;
        PageFactory.initElements(new DefaultElementLocatorFactory((SearchContext)driverRef), page);
    }

    public static void initElements(ElementLocatorFactory factory, Object page) {
        ElementLocatorFactory factoryRef = factory;
        PageFactory.initElements(new DefaultFieldDecorator(factoryRef), page);
    }

    public static void initElements(FieldDecorator decorator, Object page) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            PageFactory.proxyFields(decorator, page, proxyIn);
        }
    }

    private static void proxyFields(FieldDecorator decorator, Object page, Class<?> proxyIn) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            Object value = decorator.decorate(page.getClass().getClassLoader(), field);
            if (value == null) continue;
            try {
                field.setAccessible(true);
                field.set(page, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static <T> T instantiatePage(WebDriver driver, Class<T> pageClassToProxy) {
        try {
            try {
                Constructor<T> constructor = pageClassToProxy.getConstructor(WebDriver.class);
                return constructor.newInstance(driver);
            }
            catch (NoSuchMethodException e) {
                return pageClassToProxy.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

