/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.LitePushConsumer;
import org.apache.rocketmq.client.apis.consumer.LitePushConsumerBuilder;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.LitePushConsumerImpl;

public class LitePushConsumerBuilderImpl
implements LitePushConsumerBuilder {
    protected String bindTopic = null;
    protected ClientConfiguration clientConfiguration = null;
    protected String consumerGroup = null;
    protected Map<String, FilterExpression> subscriptionExpressions = null;
    protected MessageListener messageListener = null;
    protected int maxCacheMessageCount = 1024;
    protected int maxCacheMessageSizeInBytes = 0x4000000;
    protected int consumptionThreadCount = 20;

    public LitePushConsumerBuilder bindTopic(String bindTopic) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)bindTopic), (Object)"bindTopic should not be blank");
        this.bindTopic = bindTopic;
        return this;
    }

    public LitePushConsumerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = (ClientConfiguration)Preconditions.checkNotNull((Object)clientConfiguration, (Object)"clientConfiguration should not be null");
        return this;
    }

    public LitePushConsumerBuilder setConsumerGroup(String consumerGroup) {
        Preconditions.checkNotNull((Object)consumerGroup, (Object)"consumerGroup should not be null");
        Preconditions.checkArgument((boolean)ConsumerImpl.CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches(), (String)"consumerGroup does not match the regex [regex=%s]", (Object)ConsumerImpl.CONSUMER_GROUP_PATTERN.pattern());
        this.consumerGroup = consumerGroup;
        return this;
    }

    public LitePushConsumerBuilder setMessageListener(MessageListener messageListener) {
        this.messageListener = (MessageListener)Preconditions.checkNotNull((Object)messageListener, (Object)"messageListener should not be null");
        return this;
    }

    public LitePushConsumerBuilder setMaxCacheMessageCount(int maxCachedMessageCount) {
        Preconditions.checkArgument((maxCachedMessageCount > 0 ? 1 : 0) != 0, (Object)"maxCachedMessageCount should be positive");
        this.maxCacheMessageCount = maxCachedMessageCount;
        return this;
    }

    public LitePushConsumerBuilder setMaxCacheMessageSizeInBytes(int maxCacheMessageSizeInBytes) {
        Preconditions.checkArgument((maxCacheMessageSizeInBytes > 0 ? 1 : 0) != 0, (Object)"maxCacheMessageSizeInBytes should be positive");
        this.maxCacheMessageSizeInBytes = maxCacheMessageSizeInBytes;
        return this;
    }

    public LitePushConsumerBuilder setConsumptionThreadCount(int consumptionThreadCount) {
        Preconditions.checkArgument((consumptionThreadCount > 0 ? 1 : 0) != 0, (Object)"consumptionThreadCount should be positive");
        this.consumptionThreadCount = consumptionThreadCount;
        return this;
    }

    public LitePushConsumer build() throws ClientException {
        Preconditions.checkNotNull((Object)this.clientConfiguration, (Object)"clientConfiguration has not been set yet");
        Preconditions.checkNotNull((Object)this.consumerGroup, (Object)"consumerGroup has not been set yet");
        Preconditions.checkNotNull((Object)this.messageListener, (Object)"messageListener has not been set yet");
        Preconditions.checkNotNull((Object)this.bindTopic, (Object)"bindTopic has not been set yet");
        this.subscriptionExpressions = ImmutableMap.of((Object)this.bindTopic, (Object)FilterExpression.SUB_ALL);
        LitePushConsumerImpl litePushConsumer = new LitePushConsumerImpl(this);
        litePushConsumer.startAsync().awaitRunning();
        return litePushConsumer;
    }
}

