/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.version;

import aQute.bnd.version.Version;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRange {
    final Version high;
    final Version low;
    char start = (char)91;
    char end = (char)93;
    static Pattern RANGE = Pattern.compile("(\\(|\\[)\\s*((\\d{1,9})(\\.(\\d{1,9})(\\.(\\d{1,9})(\\.([-_\\da-zA-Z]+))?)?)?)\\s*,\\s*((\\d{1,9})(\\.(\\d{1,9})(\\.(\\d{1,9})(\\.([-_\\da-zA-Z]+))?)?)?)\\s*(\\)|\\])");

    public VersionRange(String string) {
        string = string.trim();
        int auto = 0;
        if (string.startsWith("@")) {
            string = string.substring(1);
            auto = 1;
        } else if (string.endsWith("@")) {
            string = string.substring(0, string.length() - 1);
            auto = 2;
        }
        Matcher m = RANGE.matcher(string);
        if (m.matches()) {
            this.start = m.group(1).charAt(0);
            String v1 = m.group(2);
            String v2 = m.group(10);
            this.low = new Version(v1);
            this.high = new Version(v2);
            this.end = m.group(18).charAt(0);
            if (this.low.compareTo(this.high) > 0) {
                throw new IllegalArgumentException("Low Range is higher than High Range: " + this.low + "-" + this.high);
            }
        } else {
            Version v = new Version(string);
            if (auto != 0) {
                this.low = v;
                this.high = auto == 1 ? new Version(v.getMajor() + 1, 0, 0) : new Version(v.getMajor(), v.getMinor() + 1, 0);
                this.start = (char)91;
                this.end = (char)41;
            } else {
                this.low = this.high = v;
            }
        }
    }

    public VersionRange(boolean b, Version lower, Version upper, boolean c) {
        this.start = (char)(b ? 91 : 40);
        this.end = (char)(c ? 93 : 41);
        this.low = lower;
        this.high = upper;
    }

    public boolean isRange() {
        return this.high != this.low;
    }

    public boolean includeLow() {
        return this.start == '[';
    }

    public boolean includeHigh() {
        return this.end == ']';
    }

    public String toString() {
        if (this.high == this.low) {
            return this.high.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.start);
        sb.append(this.low);
        sb.append(',');
        sb.append(this.high);
        sb.append(this.end);
        return sb.toString();
    }

    public Version getLow() {
        return this.low;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean includes(Version v) {
        if (!this.isRange()) {
            return this.low.compareTo(v) <= 0;
        }
        if (this.includeLow() ? v.compareTo(this.low) < 0 : v.compareTo(this.low) <= 0) {
            return false;
        }
        return !(this.includeHigh() ? v.compareTo(this.high) > 0 : v.compareTo(this.high) >= 0);
    }

    public Iterable<Version> filter(Iterable<Version> versions) {
        ArrayList<Version> list = new ArrayList<Version>();
        for (Version v : versions) {
            if (!this.includes(v)) continue;
            list.add(v);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toFilter() {
        Formatter f = new Formatter();
        try {
            if (this.isRange()) {
                f.format("(&", new Object[0]);
                if (this.includeLow()) {
                    f.format("(version>=%s)", this.getLow());
                } else {
                    f.format("(!(version<=%s))", this.getLow());
                }
                if (this.includeHigh()) {
                    f.format("(version<=%s)", this.getHigh());
                } else {
                    f.format("(!(version>=%s))", this.getHigh());
                }
                f.format(")", new Object[0]);
            } else {
                f.format("(version>=%s)", this.getLow());
            }
            String string = ((Object)f).toString();
            return string;
        }
        finally {
            f.close();
        }
    }

    public static boolean isVersionRange(String stringRange) {
        return RANGE.matcher(stringRange).matches();
    }
}

