/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.commands.help.wikidoc;

import java.io.PrintStream;
import org.apache.karaf.shell.impl.console.commands.help.wikidoc.WikiVisitor;
import org.apache.karaf.shell.support.table.ShellTable;
import org.fusesource.jansi.Ansi;

public class AnsiPrintingWikiVisitor
implements WikiVisitor {
    private PrintStream out;
    private int maxSize;
    private StringBuilder sb = new StringBuilder();
    private String indent;

    public AnsiPrintingWikiVisitor(PrintStream out, int maxSize) {
        this.out = out;
        this.maxSize = maxSize;
    }

    @Override
    public void startPara(int size) {
        this.indent = "";
        while (size-- > 0) {
            this.indent = this.indent + " ";
        }
    }

    @Override
    public void endPara() {
        if (this.sb.length() > 0) {
            ShellTable table = new ShellTable().noHeaders().separator("").size(this.maxSize - 1);
            table.column("").maxSize(this.indent.length());
            table.column("").wrap();
            table.addRow().addContent(this.indent, this.sb.toString());
            table.print(this.out);
            this.sb.setLength(0);
        } else {
            this.out.println();
        }
    }

    @Override
    public void heading(int level, String header) {
        this.sb.append(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(header).a(Ansi.Attribute.INTENSITY_BOLD_OFF).toString());
    }

    @Override
    public void link(String target, String title) {
        this.sb.append(Ansi.ansi().fg(Ansi.Color.YELLOW).a(target).fg(Ansi.Color.DEFAULT));
    }

    @Override
    public void enumeration(String text) {
        this.sb.append(Ansi.ansi().a(" * ").fg(Ansi.Color.CYAN).a(text).fg(Ansi.Color.DEFAULT).a(" "));
    }

    @Override
    public void text(String text) {
        this.sb.append(text);
    }

    @Override
    public void bold(boolean on) {
        if (on) {
            this.sb.append(Ansi.ansi().bold().toString());
        } else {
            this.sb.append(Ansi.ansi().boldOff().toString());
        }
    }
}

