/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.completers;

import java.io.File;
import java.util.List;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;

public class FileCompleter
implements Completer {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static final boolean OS_IS_WINDOWS = FileCompleter.isWindows();

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    @Override
    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        if (candidates == null) {
            return 0;
        }
        String buffer = commandLine.getCursorArgument();
        String string = buffer = buffer != null ? buffer.substring(0, commandLine.getArgumentPosition()) : "";
        if (OS_IS_WINDOWS) {
            buffer = buffer.replace('/', '\\');
        }
        String translated = buffer;
        File homeDir = this.getUserHome();
        if (translated.startsWith("~" + this.separator())) {
            translated = homeDir.getPath() + translated.substring(1);
        } else if (translated.startsWith("~")) {
            translated = homeDir.getParentFile().getAbsolutePath();
        } else if (!translated.startsWith(this.separator())) {
            String cwd = this.getUserDir().getAbsolutePath();
            translated = cwd + this.separator() + translated;
        }
        File file = new File(translated);
        File dir = translated.endsWith(this.separator()) ? file : file.getParentFile();
        File[] entries = dir == null ? new File[]{} : dir.listFiles();
        return this.matchFiles(buffer, translated, entries, candidates) + commandLine.getBufferPosition() - commandLine.getArgumentPosition();
    }

    protected String separator() {
        return File.separator;
    }

    protected File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    protected File getUserDir() {
        return new File(".");
    }

    protected int matchFiles(String buffer, String translated, File[] files, List<String> candidates) {
        if (files == null) {
            return -1;
        }
        int matches = 0;
        for (File file : files) {
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            ++matches;
        }
        for (File file : files) {
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            String name = file.getName() + (matches == 1 && file.isDirectory() ? this.separator() : " ");
            candidates.add(this.render(file, name).toString());
        }
        int index = buffer.lastIndexOf(this.separator());
        return index + this.separator().length();
    }

    protected CharSequence render(File file, CharSequence name) {
        return name;
    }
}

