/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util.jar;

import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;

public class BundleJarEntry
extends JarEntry {
    private final URL entryURL;
    private final Manifest manifest;

    public BundleJarEntry(String name, URL entryURL, Manifest manifest) {
        super(BundleJarEntry.removeSlash(name));
        this.entryURL = entryURL;
        this.manifest = manifest;
    }

    private static String removeSlash(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public URL getEntryURL() {
        return this.entryURL;
    }

    public Attributes getAttributes() throws IOException {
        if (this.manifest == null) {
            return null;
        }
        return this.manifest.getAttributes(this.getName());
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public void setTime(long time) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not change the time of unpacked jar entry");
    }

    public long getTime() {
        return -1L;
    }

    public void setSize(long size) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not change the size of unpacked jar entry");
    }

    public long getSize() {
        return -1L;
    }

    public long getCompressedSize() {
        return this.getSize();
    }

    public void setCompressedSize(long compressedSize) {
        throw new UnsupportedOperationException("Can not change the compressed size of unpacked jar entry");
    }

    public long getCrc() {
        return super.getCrc();
    }

    public void setCrc(long crc) {
        throw new UnsupportedOperationException("Can not change the crc of unpacked jar entry");
    }

    public int getMethod() {
        return 0;
    }

    public void setMethod(int method) {
        throw new UnsupportedOperationException("Can not change the method of unpacked jar entry");
    }

    public byte[] getExtra() {
        return null;
    }

    public void setExtra(byte[] extra) {
        throw new UnsupportedOperationException("Can not change the extra data of unpacked jar entry");
    }

    public String getComment() {
        return null;
    }

    public void setComment(String comment) {
        throw new UnsupportedOperationException("Can not change the comment of unpacked jar entry");
    }

    public boolean isDirectory() {
        return this.entryURL.getPath().endsWith("/");
    }
}

