/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.DispatcherType;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.apache.felix.http.base.internal.registry.PathResolver;
import org.apache.felix.http.base.internal.registry.PathResolverFactory;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.dto.FilterDTOBuilder;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

public final class FilterRegistry {
    private volatile List<FilterRegistrationStatus> filters = Collections.emptyList();

    public synchronized void addFilter(@Nonnull FilterHandler handler) {
        int result = handler.init();
        PathResolver[] prs = null;
        if (result == -1) {
            ArrayList<PathResolver> resolvers = new ArrayList<PathResolver>();
            if (handler.getFilterInfo().getPatterns() != null) {
                for (String pattern : handler.getFilterInfo().getPatterns()) {
                    resolvers.add(PathResolverFactory.createPatternMatcher(null, pattern));
                }
            }
            if (handler.getFilterInfo().getRegexs() != null) {
                for (String regex : handler.getFilterInfo().getRegexs()) {
                    resolvers.add(PathResolverFactory.createRegexMatcher(regex));
                }
            }
            Collections.sort(resolvers);
            prs = resolvers.toArray(new PathResolver[resolvers.size()]);
        }
        FilterRegistrationStatus status = new FilterRegistrationStatus(handler, prs, result);
        ArrayList<FilterRegistrationStatus> newList = new ArrayList<FilterRegistrationStatus>(this.filters);
        newList.add(status);
        Collections.sort(newList);
        this.filters = newList;
    }

    public synchronized void removeFilter(@Nonnull FilterInfo filterInfo, boolean destroy) {
        FilterRegistrationStatus found = null;
        ArrayList<FilterRegistrationStatus> newList = new ArrayList<FilterRegistrationStatus>(this.filters);
        Iterator i = newList.iterator();
        while (i.hasNext()) {
            FilterRegistrationStatus status = (FilterRegistrationStatus)i.next();
            if (!status.getHandler().getFilterInfo().equals(filterInfo)) continue;
            found = status;
            i.remove();
            break;
        }
        if (found != null) {
            this.filters = newList;
            if (found.getResult() == -1 && destroy) {
                found.getHandler().dispose();
            }
        }
    }

    public synchronized void cleanup() {
        this.filters = Collections.emptyList();
    }

    @Nonnull
    public FilterHandler[] getFilterHandlers(@CheckForNull ServletHandler handler, @Nonnull DispatcherType dispatcherType, @Nonnull String requestURI) {
        ArrayList<FilterHandler> result = new ArrayList<FilterHandler>();
        List<FilterRegistrationStatus> allFilters = this.filters;
        block0: for (FilterRegistrationStatus status : allFilters) {
            String servletName;
            if (status.getResult() != -1) break;
            if (!this.referencesDispatcherType(status.getHandler(), dispatcherType)) continue;
            boolean added = false;
            for (PathResolver resolver : status.getResolvers()) {
                if (resolver.resolve(requestURI) == null) continue;
                result.add(status.getHandler());
                added = true;
                break;
            }
            String string = servletName = handler != null && !handler.getServletInfo().isResource() ? handler.getName() : null;
            if (added || servletName == null || status.getHandler().getFilterInfo().getServletNames() == null) continue;
            for (String name : status.getHandler().getFilterInfo().getServletNames()) {
                if (!servletName.equals(name)) continue;
                result.add(status.getHandler());
                added = true;
                continue block0;
            }
        }
        return result.toArray(new FilterHandler[result.size()]);
    }

    private boolean referencesDispatcherType(FilterHandler handler, DispatcherType dispatcherType) {
        for (DispatcherType dt : handler.getFilterInfo().getDispatcher()) {
            if (dt != dispatcherType) continue;
            return true;
        }
        return false;
    }

    public void getRuntimeInfo(ServletContextDTO servletContextDTO, Collection<FailedFilterDTO> failedFilterDTOs) {
        ArrayList<FilterDTO> filterDTOs = new ArrayList<FilterDTO>();
        List<FilterRegistrationStatus> allFilters = this.filters;
        for (FilterRegistrationStatus status : allFilters) {
            if (status.getResult() != -1) {
                failedFilterDTOs.add((FailedFilterDTO)FilterDTOBuilder.build(status.getHandler(), status.getResult()));
                continue;
            }
            filterDTOs.add(FilterDTOBuilder.build(status.getHandler(), status.getResult()));
        }
        if (!filterDTOs.isEmpty()) {
            servletContextDTO.filterDTOs = filterDTOs.toArray(new FilterDTO[filterDTOs.size()]);
        }
    }

    private static final class FilterRegistrationStatus
    implements Comparable<FilterRegistrationStatus> {
        private final int result;
        private final FilterHandler handler;
        private final PathResolver[] resolvers;

        public FilterRegistrationStatus(@Nonnull FilterHandler handler, @CheckForNull PathResolver[] resolvers, int result) {
            this.handler = handler;
            this.resolvers = resolvers;
            this.result = result;
        }

        public int getResult() {
            return this.result;
        }

        @Nonnull
        public FilterHandler getHandler() {
            return this.handler;
        }

        @CheckForNull
        public PathResolver[] getResolvers() {
            return this.resolvers;
        }

        @Override
        public int compareTo(FilterRegistrationStatus o) {
            int result = this.result - o.result;
            if (result == 0) {
                result = this.handler.compareTo(o.handler);
            }
            return result;
        }
    }
}

