/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.apache.felix.eventadmin.impl.handler.EventHandlerProxy;
import org.apache.felix.eventadmin.impl.tasks.BlacklistLatch;
import org.osgi.service.event.Event;

public class HandlerTask
implements Runnable {
    private final EventHandlerProxy task;
    private final Event event;
    private final long timeout;
    private final BlacklistLatch handlerLatch;
    private volatile long threadId;
    private volatile long startTime;
    private volatile long endTime;

    public HandlerTask(EventHandlerProxy task, Event event, long timeout, BlacklistLatch handlerLatch) {
        this.task = task;
        this.event = event;
        this.timeout = timeout;
        this.handlerLatch = handlerLatch;
        this.threadId = -1L;
        this.startTime = -1L;
        this.endTime = -1L;
    }

    public long getTimeInMillis() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isThreadCpuTimeEnabled() ? bean.getThreadCpuTime(this.threadId) / 1000000L : System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.threadId = Thread.currentThread().getId();
            this.startTime = this.getTimeInMillis();
            this.task.sendEvent(this.event);
            this.endTime = this.getTimeInMillis();
            this.checkForBlacklist();
        }
        finally {
            this.handlerLatch.countDown();
        }
    }

    public void runWithoutBlacklistTiming() {
        this.task.sendEvent(this.event);
        this.handlerLatch.countDown();
    }

    public boolean useTimeout() {
        if (this.timeout > 0L) {
            return this.task.useTimeout();
        }
        return false;
    }

    public void checkForBlacklist() {
        if (this.useTimeout() && this.getTaskTime() > this.timeout) {
            this.task.blackListHandler();
        }
    }

    public long getTaskTime() {
        if (this.threadId < 0L || this.startTime < 0L) {
            return 0L;
        }
        if (this.endTime < 0L) {
            return this.getTimeInMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }
}

