/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ConfigurationHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public abstract class DefaultEndpointConfiguration
implements EndpointConfiguration {
    private final CamelContext camelContext;
    private URI uri;

    public DefaultEndpointConfiguration(CamelContext camelContext) {
        ObjectHelper.notNull(camelContext, "CamelContext");
        this.camelContext = camelContext;
    }

    public DefaultEndpointConfiguration(CamelContext camelContext, String uri) {
        this(camelContext);
        try {
            this.setURI(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.parseURI();
    }

    public void setURI(String uri) {
        try {
            String encoded = UnsafeUriCharactersEncoder.encode(uri);
            this.setURI(new URI(encoded));
        }
        catch (URISyntaxException e) {
            throw new RuntimeCamelException("Cannot parse uri: " + uri, e);
        }
    }

    @Override
    public <T> T getParameter(String name) {
        return (T)ConfigurationHelper.getConfigurationParameter((EndpointConfiguration)this, name);
    }

    @Override
    public <T> void setParameter(String name, T value) {
        ConfigurationHelper.setConfigurationField(this.camelContext, this, name, value);
    }

    protected CamelContext getCamelContext() {
        return this.camelContext;
    }

    protected void parseURI() {
        ConfigurationHelper.populateFromURI(this.camelContext, this, new ConfigurationHelper.FieldParameterSetter());
    }
}

