/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.RouteAware;
import org.apache.camel.Service;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.DefaultRoute;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.EndpointHelper;

public class EventDrivenConsumerRoute
extends DefaultRoute {
    private final Processor processor;
    private Consumer consumer;

    public EventDrivenConsumerRoute(RouteContext routeContext, Endpoint endpoint, Processor processor) {
        super(routeContext, endpoint);
        this.processor = processor;
    }

    @Override
    public String toString() {
        return "EventDrivenConsumerRoute[" + this.getEndpoint() + " -> " + this.processor + "]";
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void addServices(List<Service> services) throws Exception {
        Processor processor;
        Endpoint endpoint = this.getEndpoint();
        this.consumer = endpoint.createConsumer(this.processor);
        if (this.consumer != null) {
            services.add(this.consumer);
            if (this.consumer instanceof RouteAware) {
                ((RouteAware)((Object)this.consumer)).setRoute(this);
            }
        }
        if ((processor = this.getProcessor()) instanceof Service) {
            services.add((Service)((Object)processor));
        }
    }

    @Override
    public Navigate<Processor> navigate() {
        Processor answer = this.getProcessor();
        if (answer instanceof Navigate) {
            Object first;
            Navigate nav = (Navigate)((Object)answer);
            if (nav.next().size() == 1 && (first = nav.next().get(0)) instanceof Navigate) {
                return (Navigate)first;
            }
            return (Navigate)((Object)answer);
        }
        return null;
    }

    @Override
    public List<Processor> filter(String pattern) {
        ArrayList<Processor> match = new ArrayList<Processor>();
        this.doFilter(pattern, this.navigate(), match);
        return match;
    }

    private void doFilter(String pattern, Navigate<Processor> nav, List<Processor> match) {
        List<Processor> list = nav.next();
        if (list != null) {
            for (Processor proc : list) {
                String id = null;
                if (proc instanceof IdAware) {
                    id = ((IdAware)((Object)proc)).getId();
                }
                if (EndpointHelper.matchPattern(id, pattern)) {
                    match.add(proc);
                }
                if (!(proc instanceof Navigate)) continue;
                Navigate child = (Navigate)((Object)proc);
                this.doFilter(pattern, child, match);
            }
        }
    }

    @Override
    public Consumer getConsumer() {
        return this.consumer;
    }

    @Override
    public boolean supportsSuspension() {
        return this.consumer instanceof SuspendableService;
    }
}

