/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.ansi.AnsiSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="more", description="File pager.")
@Service
public class MoreAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="--lines", description="stop after N lines")
    int lines;
    @Reference(optional=true)
    Terminal terminal;
    @Reference
    Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        if (this.terminal == null || !this.isTty(System.out)) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                MoreAction.checkInterrupted();
            }
            return null;
        }
        boolean echo = this.terminal.isEchoEnabled();
        this.terminal.setEchoEnabled(false);
        try {
            if (this.lines == 0) {
                this.lines = this.terminal.getHeight();
            }
            AnsiSplitter.AnsiBufferedReader reader = AnsiSplitter.splitter((InputStream)System.in, (int)this.terminal.getWidth(), (int)4);
            int count = 0;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    Object var6_9 = null;
                    return var6_9;
                }
                System.out.println(line);
                MoreAction.checkInterrupted();
                if (++count < this.lines - 2) continue;
                int c = -1;
                while (c == -1) {
                    System.out.flush();
                    System.out.print("--More--");
                    System.out.flush();
                    c = this.session.getKeyboard().read();
                    switch (c) {
                        case -1: 
                        case 113: {
                            c = 113;
                            break;
                        }
                        case 10: 
                        case 13: 
                        case 14: {
                            --count;
                            System.out.print("\r          \r");
                            break;
                        }
                        case 32: {
                            count = 0;
                            System.out.print("\r          \r");
                            break;
                        }
                        default: {
                            c = -1;
                            System.out.print("\r          \r");
                        }
                    }
                    if (c != 113) continue;
                }
                if (c == 113) break;
            }
        }
        catch (InterruptedException ie) {
            this.log.debug("Interrupted by user");
        }
        finally {
            this.terminal.setEchoEnabled(echo);
        }
        return null;
    }

    protected boolean isTty(OutputStream out) {
        try {
            Method mth = out.getClass().getDeclaredMethod("getCurrent", new Class[0]);
            mth.setAccessible(true);
            Object current = mth.invoke((Object)out, new Object[0]);
            return current == this.session.getConsole();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void checkInterrupted() throws InterruptedException {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }
}

