/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

public class BufferUtils {
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String printHex(byte[] array) {
        return BufferUtils.printHex(array, 0, array.length);
    }

    public static String printHex(byte[] array, int offset, int len) {
        return BufferUtils.printHex(array, offset, len, ' ');
    }

    public static String printHex(byte[] array, int offset, int len, char sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b = array[offset + i];
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(digits[b >> 4 & 0xF]);
            sb.append(digits[b & 0xF]);
        }
        return sb.toString();
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        return BufferUtils.equals(a1, 0, a2, 0, a1.length);
    }

    public static boolean equals(byte[] a1, int a1Offset, byte[] a2, int a2Offset, int length) {
        if (a1.length < a1Offset + length || a2.length < a2Offset + length) {
            return false;
        }
        while (length-- > 0) {
            if (a1[a1Offset++] == a2[a2Offset++]) continue;
            return false;
        }
        return true;
    }
}

