/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.AnnotationFormatError;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.servicemix.specs.locator.OsgiLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEngineManager {
    private final Set engineSpis = new HashSet();
    private final Map<String, ScriptEngineFactory> byName = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> registeredByName = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> byExtension = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> registeredByExtension = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> byMimeType = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> registeredByMimeType = new HashMap<String, ScriptEngineFactory>();
    private Bindings globalScope;

    public ScriptEngineManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ScriptEngineManager(ClassLoader classLoader) {
        try {
            Enumeration<URL> factoryResources = classLoader.getResources("META-INF/services/javax.script.ScriptEngineFactory");
            while (factoryResources.hasMoreElements()) {
                URL url = factoryResources.nextElement();
                for (String className : this.getClassNames(url)) {
                    try {
                        Class<?> factoryClass = classLoader.loadClass(className);
                        Object object = factoryClass.newInstance();
                        if (!(object instanceof ScriptEngineFactory)) continue;
                        ScriptEngineFactory factory = (ScriptEngineFactory)object;
                        for (String name : factory.getNames()) {
                            this.byName.put(name, factory);
                        }
                        for (String extension : factory.getExtensions()) {
                            this.byExtension.put(extension, factory);
                        }
                        for (String mimeType : factory.getMimeTypes()) {
                            this.byMimeType.put(mimeType, factory);
                        }
                        this.engineSpis.add(factory);
                    }
                    catch (ClassNotFoundException doNothing) {
                    }
                    catch (IllegalAccessException doNothing) {
                    }
                    catch (InstantiationException doNothing) {
                    }
                    catch (LinkageError doNothing) {
                    }
                    catch (AnnotationFormatError doNothing) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Bindings getGlobalScope() {
        return this.globalScope;
    }

    public void setGlobalScope(Bindings globalScope) {
        this.globalScope = globalScope;
    }

    public void put(String key, Object value) {
        if (this.globalScope != null) {
            this.globalScope.put(key, value);
        }
    }

    public Object get(String key) {
        if (this.globalScope != null) {
            return this.globalScope.get(key);
        }
        return null;
    }

    public ScriptEngine getEngineByName(String shortName) {
        ScriptEngineFactory factory = null;
        List<Class<ScriptEngineFactory>> factoryClasses = OsgiLocator.locateAll(ScriptEngineFactory.class);
        for (Class<ScriptEngineFactory> factoryClass : factoryClasses) {
            try {
                ScriptEngineFactory f = factoryClass.newInstance();
                if (!f.getNames().contains(shortName)) continue;
                factory = f;
                break;
            }
            catch (Throwable doNothing) {
            }
        }
        if (factory == null) {
            factory = this.registeredByName.get(shortName);
        }
        if (factory == null) {
            factory = this.byName.get(shortName);
        }
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.setBindings(this.globalScope, 200);
        return engine;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngineFactory factory = null;
        List<Class<ScriptEngineFactory>> factoryClasses = OsgiLocator.locateAll(ScriptEngineFactory.class);
        for (Class<ScriptEngineFactory> factoryClass : factoryClasses) {
            try {
                ScriptEngineFactory f = factoryClass.newInstance();
                if (!f.getExtensions().contains(extension)) continue;
                factory = f;
                break;
            }
            catch (Throwable doNothing) {
            }
        }
        if (factory == null) {
            factory = this.registeredByExtension.get(extension);
        }
        if (factory == null) {
            factory = this.byExtension.get(extension);
        }
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.setBindings(this.globalScope, 200);
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngineFactory factory = null;
        List<Class<ScriptEngineFactory>> factoryClasses = OsgiLocator.locateAll(ScriptEngineFactory.class);
        for (Class<ScriptEngineFactory> factoryClass : factoryClasses) {
            try {
                ScriptEngineFactory f = factoryClass.newInstance();
                if (!f.getMimeTypes().contains(mimeType)) continue;
                factory = f;
                break;
            }
            catch (Throwable doNothing) {
            }
        }
        if (factory == null) {
            factory = this.registeredByMimeType.get(mimeType);
        }
        if (factory == null) {
            factory = this.byMimeType.get(mimeType);
        }
        if (factory == null) {
            return null;
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.setBindings(this.globalScope, 200);
        return engine;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> factories = new ArrayList<ScriptEngineFactory>();
        List<Class<ScriptEngineFactory>> factoryClasses = OsgiLocator.locateAll(ScriptEngineFactory.class);
        for (Class<ScriptEngineFactory> factoryClass : factoryClasses) {
            try {
                factories.add(factoryClass.newInstance());
            }
            catch (Throwable doNothing) {}
        }
        factories.addAll(this.engineSpis);
        return factories;
    }

    public void registerEngineName(String name, ScriptEngineFactory factory) {
        this.registeredByName.put(name, factory);
    }

    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        this.registeredByMimeType.put(type, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        this.registeredByExtension.put(extension, factory);
    }

    private Iterable<String> getClassNames(URL url) {
        Stack<String> stack = new Stack<String>();
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = r.readLine()) != null) {
                int comment = line.indexOf(35);
                if (comment != -1) {
                    line = line.substring(0, comment);
                }
                stack.push(line.trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stack;
    }
}

