/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.jaas.ReloadableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesLoader.class);
    static Map<FileNameKey, ReloadableProperties> staticCache = new HashMap<FileNameKey, ReloadableProperties>();
    protected boolean debug;

    public void init(Map options) {
        this.debug = PropertiesLoader.booleanOption("debug", options);
        if (this.debug) {
            LOG.debug("Initialized debug");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReloadableProperties load(String nameProperty, String fallbackName, Map options) {
        ReloadableProperties result;
        FileNameKey key = new FileNameKey(nameProperty, fallbackName, options);
        key.setDebug(this.debug);
        Map<FileNameKey, ReloadableProperties> map2 = staticCache;
        synchronized (map2) {
            result = staticCache.get(key);
            if (result == null) {
                result = new ReloadableProperties(key);
                staticCache.put(key, result);
            }
        }
        return result.obtained();
    }

    private static boolean booleanOption(String name, Map options) {
        return Boolean.parseBoolean((String)options.get(name));
    }

    public static void resetUsersAndGroupsCache() {
        staticCache.clear();
    }

    public class FileNameKey {
        final File file;
        final String absPath;
        final boolean reload;
        private boolean decrypt;
        private boolean debug;

        public FileNameKey(String nameProperty, String fallbackName, Map options) {
            this.file = new File(this.baseDir(options), this.stringOption(nameProperty, fallbackName, options));
            this.absPath = this.file.getAbsolutePath();
            this.reload = PropertiesLoader.booleanOption("reload", options);
            this.decrypt = PropertiesLoader.booleanOption("decrypt", options);
        }

        public boolean equals(Object other) {
            return other instanceof FileNameKey && this.absPath.equals(((FileNameKey)other).absPath);
        }

        public int hashCode() {
            return this.absPath.hashCode();
        }

        public boolean isReload() {
            return this.reload;
        }

        public File file() {
            return this.file;
        }

        public boolean isDecrypt() {
            return this.decrypt;
        }

        public void setDecrypt(boolean decrypt) {
            this.decrypt = decrypt;
        }

        private String stringOption(String key, String nameDefault, Map options) {
            Object result = options.get(key);
            return result != null ? result.toString() : nameDefault;
        }

        private File baseDir(Map options) {
            File baseDir = null;
            if (options.get("baseDir") != null) {
                baseDir = new File((String)options.get("baseDir"));
            } else if (System.getProperty("java.security.auth.login.config") != null) {
                baseDir = new File(System.getProperty("java.security.auth.login.config")).getParentFile();
            }
            if (this.debug) {
                LOG.debug("Using basedir=" + baseDir.getAbsolutePath());
            }
            return baseDir;
        }

        public String toString() {
            return "PropsFile=" + this.absPath;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isDebug() {
            return this.debug;
        }
    }
}

