/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.activemq.broker.AbstractLocker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCLocker
extends AbstractLocker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJDBCLocker.class);
    protected DataSource dataSource;
    private Statements statements;
    protected JDBCPersistenceAdapter jdbcAdapter;
    protected boolean createTablesOnStartup;
    protected int queryTimeout = -1;

    @Override
    public void configure(PersistenceAdapter adapter) throws IOException {
        if (adapter instanceof JDBCPersistenceAdapter) {
            this.jdbcAdapter = (JDBCPersistenceAdapter)adapter;
            this.dataSource = ((JDBCPersistenceAdapter)adapter).getLockDataSource();
        }
    }

    protected Statements getStatements() {
        if (this.statements == null && this.jdbcAdapter != null) {
            this.statements = this.jdbcAdapter.getStatements();
        }
        return this.statements;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    protected void setQueryTimeout(Statement statement) throws SQLException {
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setCreateTablesOnStartup(boolean createTablesOnStartup) {
        this.createTablesOnStartup = createTablesOnStartup;
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected void close(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException e1) {
                LOG.debug("exception while closing connection: " + e1, (Throwable)e1);
            }
        }
    }

    protected void close(Statement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException e1) {
                LOG.debug("exception while closing statement: " + e1, (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preStart() {
        if (this.createTablesOnStartup) {
            String[] createStatements = this.getStatements().getCreateLockSchemaStatements();
            Connection connection = null;
            Statement statement = null;
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                this.setQueryTimeout(statement);
                for (int i = 0; i < createStatements.length; ++i) {
                    LOG.debug("Executing SQL: " + createStatements[i]);
                    try {
                        statement.execute(createStatements[i]);
                        continue;
                    }
                    catch (SQLException e) {
                        LOG.info("Could not create lock tables; they could already exist. Failure was: " + createStatements[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode());
                    }
                }
                this.close(statement);
                this.close(connection);
            }
            catch (SQLException e) {
                try {
                    LOG.warn("Could not create lock tables; Failure Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode(), (Throwable)e);
                    this.close(statement);
                    this.close(connection);
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    this.close(connection);
                    throw throwable;
                }
            }
        }
    }
}

