/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class TimestampElement
extends AtomicElement<Date> {
    private final Date _value;

    TimestampElement(Element parent, Element prev, Date d) {
        super(parent, prev);
        this._value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 8 : 9;
    }

    @Override
    public Date getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.TIMESTAMP;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (size2 > b.remaining()) {
            return 0;
        }
        if (size2 == 9) {
            b.put((byte)-125);
        }
        b.putLong(this._value.getTime());
        return size2;
    }
}

