/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.osgi.service.importer.support.internal.collection.DynamicList;
import org.springframework.util.Assert;

public class DynamicSortedList
extends DynamicList {
    private final Comparator comparator;

    public DynamicSortedList() {
        this((Comparator)null);
    }

    public DynamicSortedList(Comparator c) {
        this.comparator = c;
    }

    public DynamicSortedList(Collection c) {
        this.comparator = null;
        this.addAll(c);
    }

    public DynamicSortedList(int size2) {
        super(size2);
        this.comparator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        Assert.notNull((Object)o);
        if (this.comparator == null && !(o instanceof Comparable)) {
            throw new ClassCastException("given object does not implement " + Comparable.class.getName() + " and no Comparator is set on the collection");
        }
        int index = 0;
        List list = this.storage;
        synchronized (list) {
            boolean duplicate;
            index = Collections.binarySearch(this.storage, o, this.comparator);
            boolean bl = duplicate = index >= 0;
            if (duplicate) {
                boolean stillEqual = true;
                while (index + 1 < this.storage.size() && stillEqual) {
                    stillEqual = false;
                    Object next = this.storage.get(index + 1);
                    if (!(this.comparator != null ? this.comparator.compare(o, next) == 0 : ((Comparable)o).compareTo(next) == 0)) continue;
                    stillEqual = true;
                    ++index;
                }
            } else {
                index = -index - 1;
            }
            if (duplicate) {
                super.add(index + 1, o);
            } else {
                super.add(index, o);
            }
        }
        return true;
    }

    public void add(int index, Object o) {
        throw new UnsupportedOperationException("This is a sorted list; it is illegal to specify the element position");
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("This is a sorted list; it is illegal to specify the element position");
    }

    public Object set(int index, Object o) {
        throw new UnsupportedOperationException("This is a sorted list; it is illegal to specify the element position");
    }
}

