/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache;

import java.io.Serializable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class JCacheCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final javax.cache.Cache<Object, Object> cache;
    private final boolean allowNullValues;

    public JCacheCache(javax.cache.Cache<Object, Object> jcache) {
        this(jcache, true);
    }

    public JCacheCache(javax.cache.Cache<Object, Object> jcache, boolean allowNullValues) {
        Assert.notNull(jcache, (String)"Cache must not be null");
        this.cache = jcache;
        this.allowNullValues = allowNullValues;
    }

    public final String getName() {
        return this.cache.getName();
    }

    public final javax.cache.Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value = this.cache.get(key);
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.cache.get(key));
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    public void put(Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        boolean set = this.cache.putIfAbsent(key, this.toStoreValue(value));
        return set ? null : this.get(key);
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }

        private Object readResolve() {
            return NULL_HOLDER;
        }
    }
}

