/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.util.Numbers;

abstract class BinaryFunction<R, V1, V2>
extends Node {
    private static final long serialVersionUID = -8632475810190545852L;
    protected final Expression<R, ? extends V1> expression1;
    protected final Expression<R, ? extends V2> expression2;

    protected BinaryFunction(Expression<R, ? extends V1> expression1, Expression<R, ? extends V2> expression2) {
        this.expression1 = Objects.requireNonNull(expression1);
        this.expression2 = Objects.requireNonNull(expression2);
    }

    public final Class<? super R> getResourceClass() {
        return BinaryFunction.specializedClass(this.expression1.getResourceClass(), this.expression2.getResourceClass());
    }

    public final List<Expression<R, ?>> getParameters() {
        return this.getExpressions();
    }

    public List<Expression<R, ?>> getExpressions() {
        return List.of(this.expression1, this.expression2);
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getExpressions();
    }

    protected final Number apply(Number left, Number right) {
        int type = Math.max(Numbers.getEnumConstant(left.getClass()), Numbers.getEnumConstant(right.getClass()));
        try {
            switch (type) {
                case 11: {
                    return this.applyAsDecimal((BigDecimal)Numbers.cast((Number)left, BigDecimal.class), (BigDecimal)Numbers.cast((Number)right, BigDecimal.class));
                }
                case 10: {
                    return this.applyAsInteger((BigInteger)Numbers.cast((Number)left, BigInteger.class), (BigInteger)Numbers.cast((Number)right, BigInteger.class));
                }
                case 7: {
                    return this.applyAsFraction((Fraction)Numbers.cast((Number)left, Fraction.class), (Fraction)Numbers.cast((Number)right, Fraction.class));
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return this.applyAsLong(left.longValue(), right.longValue());
                }
            }
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            this.warning(e, true);
        }
        return this.applyAsDouble(left instanceof Float ? DecimalFunctions.floatToDouble((float)((Float)left).floatValue()) : left.doubleValue(), right instanceof Float ? DecimalFunctions.floatToDouble((float)((Float)right).floatValue()) : right.doubleValue());
    }

    protected Number applyAsLong(long left, long right) {
        return null;
    }

    protected Number applyAsDouble(double left, double right) {
        return null;
    }

    protected Number applyAsFraction(Fraction left, Fraction right) {
        return null;
    }

    protected Number applyAsInteger(BigInteger left, BigInteger right) {
        return null;
    }

    protected Number applyAsDecimal(BigDecimal left, BigDecimal right) {
        return null;
    }
}

