/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=membership"})
public class MembershipOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(MembershipOperation.class);
    public static final String PN_MEMBERSHIP = ":membership";

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        ArrayList<Modification> changes = new ArrayList<Modification>();
        try {
            ArrayList groups = new ArrayList();
            Optional.ofNullable(request.getParameterValues(PN_MEMBERSHIP)).ifPresent(p -> groups.addAll(Arrays.asList(p)));
            AuthorizableWrapper authWrapper = (AuthorizableWrapper)request.getResource().adaptTo(AuthorizableWrapper.class);
            Authorizable auth = authWrapper.getAuthorizable();
            response.setPath(auth.getPath());
            changes.add(Modification.onModified((String)auth.getPath()));
            auth.declaredMemberOf().forEachRemaining(group -> {
                try {
                    if (!groups.contains(group.getPath())) {
                        log.debug("Removing member {} from {}", (Object)auth, group);
                        group.removeMember(auth);
                        changes.add(Modification.onModified((String)group.getPath()));
                    } else {
                        groups.remove(group.getPath());
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Failed to remove members", (Throwable)e);
                }
            });
            for (String path : groups) {
                Resource resource = request.getResourceResolver().getResource(path);
                if (resource == null) {
                    throw new RepositoryException("Failed to resolve authorizable at " + path);
                }
                Group group2 = (Group)((AuthorizableWrapper)resource.adaptTo(AuthorizableWrapper.class)).getAuthorizable();
                group2.addMember(auth);
                changes.add(Modification.onModified((String)group2.getPath()));
                log.debug("Adding member {} to {}", (Object)auth, (Object)group2);
            }
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            request.getResourceResolver().commit();
            response.onModified(auth.getPath());
        }
        catch (Exception e) {
            log.warn("Failed to update membership", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

