/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback;

import ch.qos.logback.core.joran.action.BaseModelAction;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.Model;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sling.commons.log.logback.internal.ConfigSourceTracker;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.joran.JoranConfiguratorWrapper;
import org.apache.sling.commons.log.logback.internal.joran.OsgiModel;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

@ProviderType
public final class OsgiAction
extends BaseModelAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Model buildCurrentModel(@NotNull SaxEventInterpretationContext interpretationContext, @NotNull String name, @NotNull Attributes attributes) {
        OsgiModel osgiModel = new OsgiModel();
        Collection<ConfigSourceTracker.ConfigSourceInfo> providers = this.getFragmentProviders();
        for (ConfigSourceTracker.ConfigSourceInfo cp : providers) {
            InputSource is = cp.getConfigProvider().getConfigSource();
            SaxEventRecorder recorder = null;
            try {
                recorder = this.populateSaxEventRecorder(is);
                List<SaxEvent> saxEvents = recorder.getSaxEventList();
                if (saxEvents.isEmpty()) {
                    this.addWarn("Empty sax event list");
                    continue;
                }
                LogConfigManager lcm = (LogConfigManager)this.getContext().getObject(LogConfigManager.class.getName());
                JoranConfiguratorWrapper genericXMLConfigurator = new JoranConfiguratorWrapper(lcm);
                genericXMLConfigurator.setContext(this.context);
                genericXMLConfigurator.getRuleStore().addPathPathMapping("included", "configuration");
                Model modelFromIncludedFile = genericXMLConfigurator.buildModelFromSaxEventList(recorder.getSaxEventList());
                if (modelFromIncludedFile == null) {
                    this.addError("Could not find valid configuration instructions. Exiting.");
                    continue;
                }
                osgiModel.getSubModels().addAll(modelFromIncludedFile.getSubModels());
            }
            catch (JoranException e) {
                this.addError("Error processing XML data in [" + String.valueOf(cp) + "]", e);
            }
            finally {
                Util.close(is);
            }
        }
        return osgiModel;
    }

    @NotNull
    private Collection<ConfigSourceTracker.ConfigSourceInfo> getFragmentProviders() {
        ConfigSourceTracker tracker = (ConfigSourceTracker)this.getContext().getObject(ConfigSourceTracker.class.getName());
        if (tracker != null) {
            return tracker.getSources();
        }
        return Collections.emptyList();
    }

    SaxEventRecorder populateSaxEventRecorder(InputSource inputSource) throws JoranException {
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        recorder.recordEvents(inputSource);
        return recorder;
    }
}

