/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.sling.jcr.repoinit.impl.DoNothingVisitor;
import org.apache.sling.repoinit.parser.operations.RegisterPrivilege;

public class PrivilegeVisitor
extends DoNothingVisitor {
    public PrivilegeVisitor(Session session) {
        super(session);
    }

    @Override
    public void visitRegisterPrivilege(RegisterPrivilege rp) {
        try {
            Privilege priv = ((JackrabbitWorkspace)this.session.getWorkspace()).getPrivilegeManager().getPrivilege(rp.getPrivilegeName());
            this.log.info("Privilege {} already exists: {}, no changes made.", (Object)rp.getPrivilegeName(), (Object)priv);
        }
        catch (AccessControlException ace) {
            try {
                ((JackrabbitWorkspace)this.session.getWorkspace()).getPrivilegeManager().registerPrivilege(rp.getPrivilegeName(), rp.isAbstract(), rp.getDeclaredAggregateNames().toArray(new String[0]));
            }
            catch (Exception ex) {
                this.report(ex, "Unable to register privilege from: " + rp);
            }
        }
        catch (Exception e) {
            this.report(e, "Unable to register privilege from: " + rp);
        }
    }
}

