/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.teleporter.customizers;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.serversetup.instance.SlingTestBase;
import org.apache.sling.testing.teleporter.client.ClientSideTeleporter;
import org.apache.sling.testing.timeouts.TimeoutsProvider;

public class SM_TeleporterCustomizer
implements TeleporterRule.Customizer {
    private static final SlingTestBase S = new SlingTestBase();
    private static final Class[] EXPECTED_COMPONENTS = new Class[]{ModelAdapterFactory.class};

    public void customize(TeleporterRule t, String options) {
        ClientSideTeleporter cst = (ClientSideTeleporter)t;
        cst.setBaseUrl(S.getServerBaseUrl());
        cst.setServerCredentials(S.getServerUsername(), S.getServerPassword());
        cst.setTestReadyTimeoutSeconds(TimeoutsProvider.getInstance().getTimeout(5));
        cst.includeDependencyPrefix("org.apache.sling.models.it.testing");
        try (OsgiConsoleClient osgiClient = new OsgiConsoleClient(URI.create(S.getServerBaseUrl()), S.getServerUsername(), S.getServerPassword());){
            for (Class clazz : EXPECTED_COMPONENTS) {
                osgiClient.waitComponentRegistered(clazz.getName(), 20000L, 200L);
            }
        }
        catch (IOException | InterruptedException | TimeoutException | ClientException ex) {
            throw new RuntimeException("Error waiting for expected components.", ex);
        }
    }
}

