/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl.predicates;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.filter.impl.predicates.ComparisonPredicates;

public class ComparisonPredicateFactory {
    private ComparisonPredicateFactory() {
    }

    public static Predicate<Resource> toPredicate(int kind, Function<Resource, Object> leftValue, Function<Resource, Object> rightValue) {
        switch (kind) {
            case 28: {
                return ComparisonPredicates.is(leftValue, rightValue);
            }
            case 29: {
                return ComparisonPredicates.isNot(leftValue, rightValue);
            }
            case 30: {
                return ComparisonPredicates.gt(leftValue, rightValue);
            }
            case 31: {
                return ComparisonPredicates.gte(leftValue, rightValue);
            }
            case 32: {
                return ComparisonPredicates.lt(leftValue, rightValue);
            }
            case 33: {
                return ComparisonPredicates.lte(leftValue, rightValue);
            }
            case 34: {
                return ComparisonPredicates.like(leftValue, rightValue);
            }
            case 35: {
                return ComparisonPredicates.like(leftValue, rightValue).negate();
            }
            case 36: {
                return ComparisonPredicates.contains(leftValue, rightValue);
            }
            case 37: {
                return ComparisonPredicates.contains(leftValue, rightValue).negate();
            }
            case 38: {
                return ComparisonPredicates.containsAny(leftValue, rightValue);
            }
            case 39: {
                return ComparisonPredicates.containsAny(leftValue, rightValue).negate();
            }
            case 40: {
                return ComparisonPredicates.in(leftValue, rightValue);
            }
            case 41: {
                return ComparisonPredicates.in(leftValue, rightValue).negate();
            }
        }
        return null;
    }
}

