/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl.predicates;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.filter.impl.predicates.Null;

public class ComparisonPredicates {
    private static final String STATEMENT_MAY_NOT_BE_NULL = "statement may not be null";

    public static Predicate<Resource> is(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, STATEMENT_MAY_NOT_BE_NULL);
        return resource -> {
            CharSequence lhValue = ComparisonPredicates.getString(lhs.apply((Resource)resource));
            CharSequence rhValue = ComparisonPredicates.getString(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return rhValue instanceof Null || lhValue instanceof Null;
            }
            return lhValue.equals(rhValue);
        };
    }

    public static Predicate<Resource> isNot(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, STATEMENT_MAY_NOT_BE_NULL);
        return resource -> {
            CharSequence lhValue = ComparisonPredicates.getString(lhs.apply((Resource)resource));
            CharSequence rhValue = ComparisonPredicates.getString(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return false;
            }
            return !lhValue.equals(rhValue);
        };
    }

    public static Predicate<Resource> like(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, "value may not be null");
        return resource -> {
            CharSequence lhValue = ComparisonPredicates.getString(lhs.apply((Resource)resource));
            CharSequence rhValue = ComparisonPredicates.getString(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return false;
            }
            return Pattern.matches(rhValue.toString(), lhValue);
        };
    }

    public static Predicate<Resource> gt(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, STATEMENT_MAY_NOT_BE_NULL);
        return resource -> {
            Number lhValue = ComparisonPredicates.getNumber(lhs.apply((Resource)resource));
            Number rhValue = ComparisonPredicates.getNumber(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return false;
            }
            lhValue = ComparisonPredicates.standardizeNumbers(lhValue, rhValue.getClass());
            rhValue = ComparisonPredicates.standardizeNumbers(rhValue, lhValue.getClass());
            if (lhValue instanceof Comparable) {
                return ((Comparable)((Object)lhValue)).compareTo(rhValue) > 0;
            }
            return false;
        };
    }

    public static Predicate<Resource> gte(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, STATEMENT_MAY_NOT_BE_NULL);
        return resource -> {
            Number lhValue = ComparisonPredicates.getNumber(lhs.apply((Resource)resource));
            Number rhValue = ComparisonPredicates.getNumber(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return false;
            }
            lhValue = ComparisonPredicates.standardizeNumbers(lhValue, rhValue.getClass());
            rhValue = ComparisonPredicates.standardizeNumbers(rhValue, lhValue.getClass());
            if (lhValue instanceof Comparable) {
                return ((Comparable)((Object)lhValue)).compareTo(rhValue) >= 0;
            }
            return false;
        };
    }

    public static Predicate<Resource> lt(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, "type value may not be null");
        return resource -> {
            Number lhValue = ComparisonPredicates.getNumber(lhs.apply((Resource)resource));
            Number rhValue = ComparisonPredicates.getNumber(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return false;
            }
            lhValue = ComparisonPredicates.standardizeNumbers(lhValue, rhValue.getClass());
            rhValue = ComparisonPredicates.standardizeNumbers(rhValue, lhValue.getClass());
            if (lhValue instanceof Comparable) {
                return ((Comparable)((Object)lhValue)).compareTo(rhValue) < 0;
            }
            return false;
        };
    }

    public static Predicate<Resource> lte(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, STATEMENT_MAY_NOT_BE_NULL);
        return resource -> {
            Number lhValue = ComparisonPredicates.getNumber(lhs.apply((Resource)resource));
            Number rhValue = ComparisonPredicates.getNumber(rhs.apply((Resource)resource));
            if (lhValue == null || rhValue == null) {
                return false;
            }
            lhValue = ComparisonPredicates.standardizeNumbers(lhValue, rhValue.getClass());
            rhValue = ComparisonPredicates.standardizeNumbers(rhValue, lhValue.getClass());
            if (lhValue instanceof Comparable) {
                return ((Comparable)((Object)lhValue)).compareTo(rhValue) <= 0;
            }
            return false;
        };
    }

    public static Predicate<Resource> contains(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(rhs, STATEMENT_MAY_NOT_BE_NULL);
        return resource -> {
            String[] lhValues = ComparisonPredicates.adaptToArray(lhs.apply((Resource)resource));
            String[] rhValues = ComparisonPredicates.adaptToArray(rhs.apply((Resource)resource));
            if (lhValues == null || rhValues == null) {
                return false;
            }
            if (lhValues.length < rhValues.length) {
                return false;
            }
            block0: for (String rhValue : rhValues) {
                for (String lhValue : lhValues) {
                    if (lhValue.equals(rhValue)) continue block0;
                }
                return false;
            }
            return true;
        };
    }

    public static Predicate<Resource> containsAny(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        return resource -> {
            String[] lhValues = ComparisonPredicates.adaptToArray(lhs.apply((Resource)resource));
            String[] rhValues = ComparisonPredicates.adaptToArray(rhs.apply((Resource)resource));
            if (lhValues == null || rhValues == null) {
                return false;
            }
            for (String rhValue : rhValues) {
                for (String lhValue : lhValues) {
                    if (!lhValue.equals(rhValue)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static Predicate<Resource> in(Function<Resource, Object> lhs, Function<Resource, Object> rhs) {
        Objects.requireNonNull(lhs, "left hand statement may not be null");
        Objects.requireNonNull(rhs, "right hand statement may not be null");
        return resource -> {
            String[] lhValues = ComparisonPredicates.adaptToArray(lhs.apply((Resource)resource));
            String[] rhValues = ComparisonPredicates.adaptToArray(rhs.apply((Resource)resource));
            if (lhValues == null || rhValues == null) {
                return false;
            }
            block0: for (String lhValue : lhValues) {
                for (String rhValue : rhValues) {
                    if (rhValue.equals(lhValue)) continue block0;
                }
                return false;
            }
            return true;
        };
    }

    private static Number standardizeNumbers(Number value, Class<? extends Number> klass) {
        if (value.getClass() == klass || value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf(value.doubleValue());
        }
        if (value instanceof Null) {
            return Double.NaN;
        }
        return BigDecimal.valueOf(value.longValue());
    }

    private static String[] adaptToArray(Object arr) {
        if (arr instanceof String[] || arr == null) {
            return (String[])arr;
        }
        ArrayList<CharSequence> response = new ArrayList<CharSequence>();
        if (arr.getClass().isArray()) {
            for (Object thing : (Object[])arr) {
                response.add(ComparisonPredicates.getString(thing));
            }
        } else {
            response.add(ComparisonPredicates.getString(arr));
        }
        return response.toArray(new String[0]);
    }

    private static CharSequence getString(Object initialValue) {
        if (initialValue == null) {
            return null;
        }
        if (initialValue instanceof CharSequence) {
            return (CharSequence)initialValue;
        }
        if (initialValue instanceof Instant) {
            return ((Instant)initialValue).atOffset(ZoneOffset.UTC).toString();
        }
        return initialValue.toString();
    }

    private static Number getNumber(Object initialValue) {
        if (initialValue == null) {
            return null;
        }
        if (initialValue instanceof Number) {
            return (Number)initialValue;
        }
        if (initialValue instanceof Instant) {
            return ((Instant)initialValue).toEpochMilli();
        }
        String value = initialValue.toString();
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException nfe2) {
                try {
                    return LocalDateTime.parse(value, DateTimeFormatter.ISO_DATE_TIME).toInstant(ZoneOffset.UTC).toEpochMilli();
                }
                catch (DateTimeParseException dtpe) {
                    return null;
                }
            }
        }
    }
}

