/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit5;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.osgi.junit5.OsgiConfigParametersExtension;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextStore;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;

final class OsgiConfigParametersStore {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{OsgiConfigParametersExtension.class});

    private OsgiConfigParametersStore() {
    }

    public static OsgiContextImpl getOsgiContextImpl(ExtensionContext extensionContext, Object testInstance) {
        return (OsgiContextImpl)OsgiConfigParametersStore.getStore(extensionContext).get(testInstance, OsgiContextImpl.class);
    }

    static OsgiContextImpl findInstanceContext(@NotNull Object testInstance) {
        return OsgiConfigParametersStore.getFieldFromTestInstance(testInstance).map(field -> OsgiConfigParametersStore.accessOsgiContextImplField(field, testInstance)).orElse(null);
    }

    static OsgiContextImpl accessOsgiContextImplField(@NotNull Field osgiContextField, Object testInstance) {
        try {
            return (OsgiContextImpl)osgiContextField.get(testInstance);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("failed to access OsgiContextImpl field", e);
        }
    }

    static Optional<Field> getFieldFromTestInstance(Object testInstance) {
        return Optional.ofNullable(testInstance).map(Object::getClass).flatMap(OsgiConfigParametersStore::getFieldFromTestClass);
    }

    static Optional<Field> getFieldFromTestClass(@NotNull Class<?> instanceClass) {
        Field contextField = Arrays.stream(instanceClass.getDeclaredFields()).filter(field -> OsgiContextImpl.class.isAssignableFrom(field.getType())).findFirst().orElse(null);
        if (contextField != null) {
            contextField.setAccessible(true);
            return Optional.of(contextField);
        }
        return Optional.ofNullable(instanceClass.getSuperclass()).flatMap(OsgiConfigParametersStore::getFieldFromTestClass);
    }

    public static OsgiContextImpl getOrCreateOsgiContext(ExtensionContext extensionContext, Object testInstance) {
        OsgiContextImpl context = Optional.ofNullable(OsgiConfigParametersStore.getOsgiContextImpl(extensionContext, testInstance)).or(() -> Optional.ofNullable(OsgiConfigParametersStore.findInstanceContext(testInstance))).orElseGet(() -> OsgiContextStore.getOrCreateOsgiContext(extensionContext, testInstance));
        OsgiConfigParametersStore.storeOsgiContext(extensionContext, testInstance, context);
        return context;
    }

    public static void storeOsgiContext(ExtensionContext extensionContext, Object testInstance, OsgiContextImpl osgiContext) {
        OsgiConfigParametersStore.getStore(extensionContext).put(testInstance, (Object)osgiContext);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(NAMESPACE);
    }
}

