# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._configuration import AuthorizationManagementClientConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_request(scope: str, role_eligibility_schedule_request_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}",
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
        "roleEligibilityScheduleRequestName": _SERIALIZER.url(
            "role_eligibility_schedule_request_name", role_eligibility_schedule_request_name, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(scope: str, role_eligibility_schedule_request_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}",
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
        "roleEligibilityScheduleRequestName": _SERIALIZER.url(
            "role_eligibility_schedule_request_name", role_eligibility_schedule_request_name, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_for_scope_request(scope: str, *, filter: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests")
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_cancel_request(scope: str, role_eligibility_schedule_request_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}/cancel",
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
        "roleEligibilityScheduleRequestName": _SERIALIZER.url(
            "role_eligibility_schedule_request_name", role_eligibility_schedule_request_name, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_validate_request(scope: str, role_eligibility_schedule_request_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}/validate",
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str", skip_quote=True),
        "roleEligibilityScheduleRequestName": _SERIALIZER.url(
            "role_eligibility_schedule_request_name", role_eligibility_schedule_request_name, "str"
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class RoleEligibilityScheduleRequestsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.authorization.AuthorizationManagementClient`'s
        :attr:`role_eligibility_schedule_requests` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AuthorizationManagementClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def create(
        self,
        scope: str,
        role_eligibility_schedule_request_name: str,
        parameters: _models.RoleEligibilityScheduleRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Creates a role eligibility schedule request.

        :param scope: The scope of the role eligibility schedule request to create. The scope can be
         any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a
         subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a
         resource group, and
         '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
         for a resource. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility to create. It
         can be any valid GUID. Required.
        :type role_eligibility_schedule_request_name: str
        :param parameters: Parameters for the role eligibility schedule request. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create(
        self,
        scope: str,
        role_eligibility_schedule_request_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Creates a role eligibility schedule request.

        :param scope: The scope of the role eligibility schedule request to create. The scope can be
         any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a
         subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a
         resource group, and
         '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
         for a resource. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility to create. It
         can be any valid GUID. Required.
        :type role_eligibility_schedule_request_name: str
        :param parameters: Parameters for the role eligibility schedule request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create(
        self,
        scope: str,
        role_eligibility_schedule_request_name: str,
        parameters: Union[_models.RoleEligibilityScheduleRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Creates a role eligibility schedule request.

        :param scope: The scope of the role eligibility schedule request to create. The scope can be
         any REST resource instance. For example, use '/subscriptions/{subscription-id}/' for a
         subscription, '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a
         resource group, and
         '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
         for a resource. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility to create. It
         can be any valid GUID. Required.
        :type role_eligibility_schedule_request_name: str
        :param parameters: Parameters for the role eligibility schedule request. Is either a
         RoleEligibilityScheduleRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest or IO[bytes]
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RoleEligibilityScheduleRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RoleEligibilityScheduleRequest")

        _request = build_create_request(
            scope=scope,
            role_eligibility_schedule_request_name=role_eligibility_schedule_request_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RoleEligibilityScheduleRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get(
        self, scope: str, role_eligibility_schedule_request_name: str, **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Get the specified role eligibility schedule request.

        :param scope: The scope of the role eligibility schedule request. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name (guid) of the role eligibility schedule
         request to get. Required.
        :type role_eligibility_schedule_request_name: str
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        cls: ClsType[_models.RoleEligibilityScheduleRequest] = kwargs.pop("cls", None)

        _request = build_get_request(
            scope=scope,
            role_eligibility_schedule_request_name=role_eligibility_schedule_request_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RoleEligibilityScheduleRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_for_scope(
        self, scope: str, filter: Optional[str] = None, **kwargs: Any
    ) -> ItemPaged["_models.RoleEligibilityScheduleRequest"]:
        """Gets role eligibility schedule requests for a scope.

        :param scope: The scope of the role eligibility schedule requests. Required.
        :type scope: str
        :param filter: The filter to apply on the operation. Use $filter=atScope() to return all role
         eligibility schedule requests at or above the scope. Use $filter=principalId eq {id} to return
         all role eligibility schedule requests at, above or below the scope for the specified
         principal. Use $filter=asRequestor() to return all role eligibility schedule requests requested
         by the current user. Use $filter=asTarget() to return all role eligibility schedule requests
         created for the current user. Use $filter=asApprover() to return all role eligibility schedule
         requests where the current user is an approver. Default value is None.
        :type filter: str
        :return: An iterator like instance of either RoleEligibilityScheduleRequest or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        cls: ClsType[_models.RoleEligibilityScheduleRequestListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_for_scope_request(
                    scope=scope,
                    filter=filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("RoleEligibilityScheduleRequestListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def cancel(  # pylint: disable=inconsistent-return-statements
        self, scope: str, role_eligibility_schedule_request_name: str, **kwargs: Any
    ) -> None:
        """Cancels a pending role eligibility schedule request.

        :param scope: The scope of the role eligibility request to cancel. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility request to
         cancel. Required.
        :type role_eligibility_schedule_request_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_cancel_request(
            scope=scope,
            role_eligibility_schedule_request_name=role_eligibility_schedule_request_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    def validate(
        self,
        scope: str,
        role_eligibility_schedule_request_name: str,
        parameters: _models.RoleEligibilityScheduleRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Validates a new role eligibility schedule request.

        :param scope: The scope of the role eligibility request to validate. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility request to
         validate. Required.
        :type role_eligibility_schedule_request_name: str
        :param parameters: Parameters for the role eligibility schedule request. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def validate(
        self,
        scope: str,
        role_eligibility_schedule_request_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Validates a new role eligibility schedule request.

        :param scope: The scope of the role eligibility request to validate. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility request to
         validate. Required.
        :type role_eligibility_schedule_request_name: str
        :param parameters: Parameters for the role eligibility schedule request. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def validate(
        self,
        scope: str,
        role_eligibility_schedule_request_name: str,
        parameters: Union[_models.RoleEligibilityScheduleRequest, IO[bytes]],
        **kwargs: Any
    ) -> _models.RoleEligibilityScheduleRequest:
        """Validates a new role eligibility schedule request.

        :param scope: The scope of the role eligibility request to validate. Required.
        :type scope: str
        :param role_eligibility_schedule_request_name: The name of the role eligibility request to
         validate. Required.
        :type role_eligibility_schedule_request_name: str
        :param parameters: Parameters for the role eligibility schedule request. Is either a
         RoleEligibilityScheduleRequest type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest or IO[bytes]
        :return: RoleEligibilityScheduleRequest or the result of cls(response)
        :rtype: ~azure.mgmt.authorization.models.RoleEligibilityScheduleRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-09-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RoleEligibilityScheduleRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RoleEligibilityScheduleRequest")

        _request = build_validate_request(
            scope=scope,
            role_eligibility_schedule_request_name=role_eligibility_schedule_request_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RoleEligibilityScheduleRequest", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
