/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.hints;

import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class CDIAnnotation
extends Annotation {
    private CDIAnnotaitonType myType;
    private Line.Part myPart;

    CDIAnnotation(CDIAnnotaitonType type, Line.Part part) {
        this.myType = type;
        this.myPart = part;
    }

    public String getAnnotationType() {
        return this.myType.toString();
    }

    public String getShortDescription() {
        switch (this.myType.ordinal()) {
            case 0: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_InjectionPoint");
            }
            case 1: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_DelegatePoint");
            }
            case 2: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_DecoratedBean");
            }
            case 3: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_Event");
            }
            case 4: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_Observer");
            }
            case 5: {
                return NbBundle.getMessage(CDIAnnotation.class, (String)"LBL_Intercepted");
            }
        }
        assert (false);
        return null;
    }

    public Line.Part getPart() {
        return this.myPart;
    }

    public static enum CDIAnnotaitonType {
        INJECTION_POINT("org-netbeans-modules-web-beans-annotations-injection-point"),
        DELEGATE_POINT("org-netbeans-modules-web-beans-annotations-delegate-point"),
        DECORATED_BEAN("org-netbeans-modules-web-beans-annotations-decorated-bean"),
        EVENT("org-netbeans-modules-web-beans-annotations-event"),
        OBSERVER("org-netbeans-modules-web-beans-annotations-observer"),
        INTERCEPTED_ELEMENT("org-netbeans-modules-editor-annotations-intercepted");

        private final String myType;

        private CDIAnnotaitonType(String type) {
            this.myType = type;
        }

        public String toString() {
            return this.myType;
        }
    }
}

