/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;

public final class CosUpdated
extends Task {
    private String id;
    private File srcdir;
    private String includes;

    public void setId(String id) {
        id.getClass();
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setSrcdir(File dir) {
        this.srcdir = dir;
    }

    public File getSrcdir() {
        return this.srcdir;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void execute() throws BuildException {
        if (this.id == null || this.id.isEmpty()) {
            throw new BuildException("The id has to be set.");
        }
        if (this.srcdir == null || !this.srcdir.isDirectory()) {
            throw new BuildException("The srcdir has to point to a directory.");
        }
        if (this.includes == null || this.includes.isEmpty()) {
            throw new BuildException("The includes has to be set.");
        }
        Project prj = this.getProject();
        CosFileSet cfs = new CosFileSet();
        cfs.setProject(prj);
        cfs.setDir(this.srcdir);
        for (String include : this.includes.split(",")) {
            if ((include = include.trim()).isEmpty()) continue;
            cfs.createInclude().setName(include);
        }
        prj.addReference(this.id, (Object)cfs);
    }

    private static final class CosFileSet
    extends FileSet {
        private CosFileSet() {
        }

        public Iterator<Resource> iterator() {
            return new CosFileSetIterator(super.iterator());
        }

        public boolean isFilesystemOnly() {
            return false;
        }

        private static final class CosFileSetIterator
        implements Iterator<Resource> {
            private final Iterator<Resource> delegate;

            CosFileSetIterator(Iterator<Resource> delegate) {
                delegate.getClass();
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Resource next() {
                return new CosResource(this.delegate.next());
            }
        }

        private static final class CosResource
        extends Resource {
            private final Resource delegate;

            CosResource(Resource delegate) {
                delegate.getClass();
                this.delegate = delegate;
            }

            public void setRefid(Reference r) {
                throw this.tooManyAttributes();
            }

            public String getName() {
                String name = this.delegate.getName();
                return name.replace(".sig", ".class");
            }

            public boolean isExists() {
                return this.delegate.isExists();
            }

            public long getLastModified() {
                return this.delegate.getLastModified();
            }

            public boolean isDirectory() {
                return this.delegate.isDirectory();
            }

            public long getSize() {
                return this.delegate.getSize();
            }

            public InputStream getInputStream() throws IOException {
                return this.delegate.getInputStream();
            }

            public OutputStream getOutputStream() throws IOException {
                return this.delegate.getOutputStream();
            }

            public int compareTo(Resource another) {
                if (another instanceof CosResource) {
                    return this.delegate.compareTo(((CosResource)another).delegate);
                }
                return this.toString().compareTo(String.valueOf(another));
            }

            public int hashCode() {
                int hash = 3;
                hash = 71 * hash + Objects.hashCode(this.delegate);
                return hash;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (((Object)((Object)this)).getClass() != obj.getClass()) {
                    return false;
                }
                return Objects.equals(this.delegate, ((CosResource)((Object)obj)).delegate);
            }

            public String toString() {
                return this.delegate.toString();
            }

            public boolean isFilesystemOnly() {
                return false;
            }
        }
    }
}

