/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CacheIndex {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.turbo.CacheIndex");
    private final Map<File, Set<File>> index = new ConcurrentHashMap<File, Set<File>>();

    protected abstract boolean isManaged(File var1);

    public File[] get(File key) {
        LOG.log(Level.FINE, "get({0})", new Object[]{key});
        if (key == null) {
            return new File[0];
        }
        Set<File> ret = this.index.get(key);
        if (ret == null) {
            LOG.log(Level.FINE, " get({0}) returns no files", new Object[]{key});
            return new File[0];
        }
        LOG.log(Level.FINE, " get({0}) returns {1}", new Object[]{key, ret.size()});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + String.valueOf(ret));
        }
        return (File[])ret.toArray(File[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getAllValues() {
        ArrayList<Set<File>> values;
        LOG.fine("getAllValues()");
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            values = new ArrayList<Set<File>>(this.index.values());
        }
        HashSet ret = new HashSet();
        for (Set set : values) {
            CacheIndex cacheIndex2 = this;
            synchronized (cacheIndex2) {
                ret.addAll(set);
            }
        }
        LOG.log(Level.FINE, " getAllValues() returns {0}", new Object[]{ret.size()});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + String.valueOf(ret));
        }
        return (File[])ret.toArray(File[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file) {
        LOG.log(Level.FINE, "add({0})", new Object[]{file});
        assert (file != null);
        if (file == null) {
            return;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            LOG.log(Level.INFO, "add: trying to add a FS root {0})", new Object[]{file});
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "add: trying to add a FS root", new Exception());
            }
            return;
        }
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            this.index.computeIfAbsent(parent, k -> {
                LOG.log(Level.FINER, "  add({0}) - creating new file entry", new Object[]{file});
                return Collections.synchronizedSet(new HashSet());
            }).add(file);
            this.ensureParents(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file, Set<File> files) {
        LOG.log(Level.FINE, "add({0}, Set<File>)", new Object[]{file});
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("   " + String.valueOf(files));
        }
        if (files == null) {
            files = new HashSet<File>(0);
        }
        HashSet<File> newSet = new HashSet<File>((int)Math.ceil((double)files.size() / 0.75));
        CacheIndex cacheIndex = this;
        synchronized (cacheIndex) {
            Set<File> oldSet = this.index.get(file);
            if (oldSet != null) {
                for (File f : oldSet) {
                    if (files.contains(f) || this.index.get(f) == null) continue;
                    newSet.add(f);
                }
            }
            newSet.addAll(files);
            LOG.log(Level.FINE, "  add({0}, Set<File>) - add entries", new Object[]{file});
            this.index.put(file, Collections.synchronizedSet(newSet));
            if (!newSet.isEmpty()) {
                this.ensureParents(file);
            } else {
                this.cleanUpParents(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParents(File file) {
        File pFile = file;
        LOG.log(Level.FINE, "  ensureParents({0})", new Object[]{pFile});
        while (true) {
            File parent = file.getParentFile();
            LOG.log(Level.FINE, "  ensureParents({0}) - parent {1}", new Object[]{pFile, parent});
            if (parent == null) {
                LOG.log(Level.FINE, "  ensureParents({0}) - done", new Object[]{pFile, parent});
                break;
            }
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                Set<File> set = this.index.get(parent);
                if (set == null) {
                    LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - no entry", new Object[]{pFile, parent});
                    if (!this.isManaged(parent)) {
                        LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - not managed - done!", new Object[]{pFile, parent});
                        break;
                    }
                    set = new HashSet<File>();
                    LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - creating parent node", new Object[]{pFile, parent});
                    this.index.put(parent, set);
                }
                LOG.log(Level.FINE, "  ensureParents({0}) - parent {1} - adding file {2}", new Object[]{pFile, parent, file});
                set.add(file);
            }
            file = parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpParents(File file) {
        File pFile = file;
        LOG.log(Level.FINE, "  cleanUpParents({0})", new Object[]{pFile});
        Set<File> set = this.index.get(file);
        if (set != null && !set.isEmpty()) {
            LOG.log(Level.FINE, "  cleanUpParents({0}) - children underneath. stop.", new Object[]{pFile});
            return;
        }
        LOG.log(Level.FINE, "  cleanUpParents({0}) - removing node", new Object[]{pFile});
        this.index.remove(file);
        while (true) {
            File parent = file.getParentFile();
            LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1}", new Object[]{pFile, parent});
            if (parent == null) {
                LOG.log(Level.FINE, "  cleanUpParents({0}) - done", new Object[]{pFile, parent});
                break;
            }
            CacheIndex cacheIndex = this;
            synchronized (cacheIndex) {
                set = this.index.get(parent);
                if (set == null) {
                    LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} empty - stop", new Object[]{pFile, parent});
                    break;
                }
                if (set.size() == 1) {
                    File lastLonelyFile = set.iterator().next();
                    if (!file.equals(lastLonelyFile) || this.index.get(lastLonelyFile) != null) {
                        break;
                    }
                } else {
                    LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} - remove file {2}", new Object[]{pFile, parent, file});
                    if (this.index.get(file) == null) {
                        set.remove(file);
                    }
                    break;
                }
                LOG.log(Level.FINE, "  cleanUpParents({0}) - parent {1} size 1 - remove", new Object[]{pFile, parent});
                this.index.remove(parent);
            }
            file = parent;
        }
    }
}

