/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.j2ee.Bundle;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.impl.ServerJavaPlatform;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public final class J2EEProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2ee");
    private static int lastAgentID = -1;
    private static int lastAgentPort = 5140;

    public J2EEProjectProfilingSupportProvider(Project project) {
        super(project);
    }

    public static int getLastAgentID() {
        return lastAgentID;
    }

    public static int getLastAgentPort() {
        return lastAgentPort;
    }

    public static void resetLastValues() {
        lastAgentID = -1;
        lastAgentPort = -1;
    }

    public static String getServerInstanceID(Project project) {
        J2eeModuleProvider serverInstanceModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (serverInstanceModuleProvider == null) {
            return null;
        }
        return serverInstanceModuleProvider.getServerInstanceID();
    }

    public JavaPlatform resolveProjectJavaPlatform() {
        String serverInstanceID = J2EEProjectProfilingSupportProvider.getServerInstanceID(this.getProject());
        if (serverInstanceID == null) {
            return null;
        }
        return ServerJavaPlatform.getPlatform(serverInstanceID);
    }

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        J2eePlatform j2eePlatform = J2EEProjectProfilingSupportProvider.getJ2eePlatform(this.getProject());
        if (j2eePlatform != null && !j2eePlatform.supportsProfiling()) {
            ProfilerDialogs.displayWarning((String)Bundle.J2EEProjectTypeProfiler_ProfilingNotSupportedMsg());
            return false;
        }
        if (profiledClassFile != null) {
            if (this.isFileObjectSupported(profiledClassFile)) {
                return true;
            }
            ProfilerDialogs.displayWarning((String)Bundle.J2EEProjectTypeProfiler_ProfilingFileNotSupportedMsg(profiledClassFile.getNameExt(), ProjectUtilities.getDisplayName((Lookup.Provider)this.getProject())));
            return false;
        }
        return true;
    }

    public boolean isFileObjectSupported(FileObject file) {
        Project project = this.getProject();
        return WebProjectUtils.isJSP(file) && WebProjectUtils.isWebDocumentSource(file, project) || WebProjectUtils.isHttpServlet(file) && WebProjectUtils.isWebJavaSource(file, project);
    }

    public static int generateAgentID() {
        int newAgentID = J2EEProjectProfilingSupportProvider.generateAgentNumber();
        while (newAgentID == lastAgentID) {
            newAgentID = J2EEProjectProfilingSupportProvider.generateAgentNumber();
        }
        lastAgentID = newAgentID;
        return J2EEProjectProfilingSupportProvider.getLastAgentID();
    }

    public static JavaPlatform generateAgentJavaPlatform(String serverInstanceID) {
        return ServerJavaPlatform.getPlatform(serverInstanceID);
    }

    public static int generateAgentPort() {
        lastAgentPort = ProfilerIDESettings.getInstance().getPortNo();
        return J2EEProjectProfilingSupportProvider.getLastAgentPort();
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        Project project = this.getProject();
        PropertyEvaluator pp = this.getProjectProperties(project);
        ss.setMainClass("");
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("build.classes.dir");
        ss.setMainClassPath(runCP != null ? MiscUtils.getAbsoluteFilePath((String)runCP, (String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath()) : "");
        ss.setJVMArgs("");
        ss.setWorkingDir("");
        super.setupProjectSessionSettings(ss);
    }

    private static J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID = J2EEProjectProfilingSupportProvider.getServerInstanceID(project);
        if (serverInstanceID == null) {
            return null;
        }
        return J2EEProjectProfilingSupportProvider.getJ2eePlatform(serverInstanceID);
    }

    private static J2eePlatform getJ2eePlatform(String serverInstanceID) {
        return Deployment.getDefault().getJ2eePlatform(serverInstanceID);
    }

    private static int generateAgentNumber() {
        return (int)(Math.random() * 2.147483648E9);
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        ProjectManager.mutex().readAccess(new Runnable(){
            final /* synthetic */ J2EEProjectProfilingSupportProvider this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is;
                if (privatePropsFile != null) {
                    try {
                        is = privatePropsFile.getInputStream();
                        try {
                            privateProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (projectPropsFile != null) {
                    try {
                        is = projectPropsFile.getInputStream();
                        try {
                            projectProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (userPropsFile != null) {
                    try {
                        is = new BufferedInputStream(new FileInputStream(userPropsFile));
                        try {
                            userPropsProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

