/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.FileActionPerformer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class FileSensitivePerformer
implements FileActionPerformer {
    private final String command;

    public FileSensitivePerformer(String command) {
        this.command = command;
    }

    static boolean supportsProfileFile(String command, FileObject file) {
        Project p;
        Project project = p = file == null ? null : FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return false;
        }
        ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        try {
            if (ap != null && FileSensitivePerformer.contains(ap.getSupportedActions(), command)) {
                ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)p);
                return ppp.isProfilingSupported() && ppp.isFileObjectSupported(file) && ap.isActionEnabled(command, FileSensitivePerformer.getContext(file, p, command));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public boolean enable(FileObject file) {
        return FileSensitivePerformer.supportsProfileFile(this.command, file);
    }

    public void perform(final FileObject file) {
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ FileSensitivePerformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Project p = FileOwnerQuery.getOwner((FileObject)file);
                ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)p);
                if (!ppp.checkProjectCanBeProfiled(file)) {
                    return;
                }
                JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)file);
                if (ppp.startProfilingSession(file, src == null ? false : src.isTest())) {
                    return;
                }
                Lookup context = FileSensitivePerformer.getContext(file, p, this.this$0.command);
                ProfilerSession session = ProfilerSession.forContext((Lookup)context);
                if (session != null) {
                    session.open();
                }
            }
        });
    }

    private static Lookup getContext(FileObject file, Project p, String command) {
        ProfilerLauncher.Command _command = new ProfilerLauncher.Command(command);
        try {
            return Lookups.fixed((Object[])new Object[]{file, p, DataObject.find((FileObject)file), _command});
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return Lookups.fixed((Object[])new Object[]{file, p, _command});
        }
    }

    private static boolean contains(String[] actions, String action) {
        for (String a : actions) {
            if (!a.equals(action)) continue;
            return true;
        }
        return false;
    }
}

