/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateTemporalAnnotationHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class TemporalFieldsAnnotated
extends JPAEntityAttributeCheck {
    private static Collection<String> temporalTypes = Arrays.asList("java.util.Calendar", "java.util.Date");

    @Override
    public Collection<ErrorDescription> check(JPAProblemContext ctx, HintContext hc, AttributeWrapper attrib) {
        String temporal = attrib.getTemporal();
        if ((temporal == null || temporal.length() == 0) && temporalTypes.contains(attrib.getType().toString())) {
            CreateTemporalAnnotationHint fix = new CreateTemporalAnnotationHint(ctx.getFileObject(), (ElementHandle<Element>)ElementHandle.create((Element)attrib.getJavaElement()));
            Tree elementTree = ctx.getCompilationInfo().getTrees().getTree(attrib.getJavaElement());
            Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
            ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(TemporalFieldsAnnotated.class, (String)"MSG_TemporalAttrNotAnnotatedProperly"), (Fix[])new Fix[]{fix});
            return Collections.singleton(error);
        }
        return null;
    }
}

