/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.lib.api.CssColor;
import org.netbeans.modules.web.common.ui.api.WebUIUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.ui.Bundle;
import org.netbeans.modules.web.inspect.webkit.ui.CustomToolbar;
import org.netbeans.modules.web.inspect.webkit.ui.EditCSSRulesAction;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedPropertiesNode;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedRulesNode;
import org.netbeans.modules.web.inspect.webkit.ui.RuleInfo;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.css.MatchedStyles;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CSSStylesSelectionPanel
extends JPanel {
    private static final boolean AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final RequestProcessor RP = new RequestProcessor(CSSStylesSelectionPanel.class);
    private transient Lookup lookup;
    private transient WebKitPageModel pageModel;
    private transient org.openide.nodes.Node inspectedNode;
    private transient Listener listener;
    private TreeTableView propertyPane;
    private ExplorerManager propertyPaneManager;
    private ListView rulePane;
    private ExplorerManager rulePaneManager;
    private EditCSSRulesAction editCSSRulesAction;
    private JPanel messagePanel;
    private JLabel messageLabel;
    private JLabel propertySummaryLabel;
    private final JComponent selectionView;
    private final Map<Resource, FileObject> resourceCache = new WeakHashMap<Resource, FileObject>();
    private static final String PSEUDO_CLASS = "pseudoClass";
    private final List<JCheckBox> pseudoClassCheckBoxes = new ArrayList<JCheckBox>(4);

    CSSStylesSelectionPanel() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = this.createSplitPane();
        splitPane.setOrientation(0);
        splitPane.setTopComponent(this.initPropertyPane());
        splitPane.setBottomComponent(this.initRulePane());
        splitPane.setDividerSize(4);
        splitPane.setResizeWeight(0.5);
        splitPane.setBorder(null);
        this.selectionView = splitPane;
        this.initMessagePanel();
        this.initSelectionOfOwningRule();
        this.add((Component)this.selectionView, "Center");
        this.updateContent(null, false);
    }

    private JSplitPane createSplitPane() {
        return new JSplitPane(){

            @Override
            public String getUIClassID() {
                if (AQUA && UIManager.get("Nb.SplitPaneUI.clean") != null) {
                    return "Nb.SplitPaneUI.clean";
                }
                return super.getUIClassID();
            }
        };
    }

    private JPanel initPropertyPane() {
        this.propertyPane = new PropertyPaneView();
        String valueTitle = NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.value");
        this.propertyPane.setProperties(new Node.Property[]{new PropertySupport.ReadOnly<String>("value", String.class, valueTitle, null){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return null;
            }
        }});
        ExplorerManagerProviderPanel propertyPanePanel = new ExplorerManagerProviderPanel();
        propertyPanePanel.setLayout(new BorderLayout());
        propertyPanePanel.add((Component)this.propertyPane, "Center");
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.propertySummaryLabel = new JLabel();
        this.propertySummaryLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.propertySummaryLabel.setMinimumSize(new Dimension(0, 0));
        titlePanel.add(this.propertySummaryLabel);
        titlePanel.add(Box.createHorizontalGlue());
        JToggleButton pseudoClassToggle = new JToggleButton();
        pseudoClassToggle.setFocusPainted(false);
        pseudoClassToggle.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/inspect/resources/elementStates.png", (boolean)true));
        pseudoClassToggle.setToolTipText(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.pseudoClasses"));
        CustomToolbar toolBar = new CustomToolbar();
        toolBar.addButton(pseudoClassToggle);
        titlePanel.add(toolBar);
        headerPanel.add((Component)titlePanel, "First");
        headerPanel.add((Component)this.createPseudoClassPanel(pseudoClassToggle), "Center");
        propertyPanePanel.add((Component)headerPanel, "First");
        this.propertyPaneManager = propertyPanePanel.getExplorerManager();
        propertyPanePanel.setMinimumSize(new Dimension(0, 0));
        return propertyPanePanel;
    }

    private JPanel createPseudoClassPanel(JToggleButton pseudoClassToggle) {
        final JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        ResourceBundle bundle = NbBundle.getBundle(CSSStylesSelectionPanel.class);
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.ACTIVE, bundle.getString("CSSStylesSelectionPanel.pseudoClass.active")));
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.HOVER, bundle.getString("CSSStylesSelectionPanel.pseudoClass.hover")));
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.FOCUS, bundle.getString("CSSStylesSelectionPanel.pseudoClass.focus")));
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.VISITED, bundle.getString("CSSStylesSelectionPanel.pseudoClass.visited")));
        panel.setVisible(false);
        pseudoClassToggle.addItemListener(new ItemListener(){
            final /* synthetic */ CSSStylesSelectionPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                JToggleButton source = (JToggleButton)e.getSource();
                panel.setVisible(source.isSelected());
            }
        });
        return panel;
    }

    private JCheckBox createPseudoCheckBox(final CSS.PseudoClass pseudoClass, String title) {
        JCheckBox checkbox = new JCheckBox(title);
        checkbox.addActionListener(new ActionListener(){
            final /* synthetic */ CSSStylesSelectionPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                WebKitPageModel model = this.this$0.pageModel;
                org.openide.nodes.Node selectedNode = this.this$0.inspectedNode;
                if (model != null && selectedNode != null) {
                    Node node = (Node)selectedNode.getLookup().lookup(Node.class);
                    JCheckBox source = (JCheckBox)e.getSource();
                    boolean checked = source.isSelected();
                    if (checked) {
                        model.addPseudoClass(node, pseudoClass);
                    } else {
                        model.removePseudoClass(node, pseudoClass);
                    }
                    this.this$0.updateMatchedRules(model, selectedNode, true);
                }
            }
        });
        checkbox.putClientProperty(PSEUDO_CLASS, pseudoClass);
        this.pseudoClassCheckBoxes.add(checkbox);
        return checkbox;
    }

    private void updatePseudoClassPanel(WebKitPageModel pageModel, Node node) {
        CSS.PseudoClass[] pseudoClasses = pageModel.getPseudoClasses(node);
        EnumSet<CSS.PseudoClass> set = EnumSet.noneOf(CSS.PseudoClass.class);
        set.addAll(Arrays.asList(pseudoClasses));
        for (JCheckBox checkbox : this.pseudoClassCheckBoxes) {
            CSS.PseudoClass pseudoClass = (CSS.PseudoClass)checkbox.getClientProperty(PSEUDO_CLASS);
            boolean selected = set.contains(pseudoClass);
            checkbox.setSelected(selected);
        }
    }

    @SuppressWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION"}, justification="The instances are never serialized.")
    private JPanel initRulePane() {
        this.rulePane = new ListView(){
            {
                final StylesRenderer renderer = new StylesRenderer(CSSStylesSelectionPanel.this.resourceCache);
                this.list.setCellRenderer(renderer);
                MouseAdapter adapter = new MouseAdapter(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (this.isLink(e)) {
                            this.this$1.list.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            this.this$1.list.setCursor(Cursor.getDefaultCursor());
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        this.this$1.list.setCursor(Cursor.getDefaultCursor());
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (this.isLink(e)) {
                            Point p = e.getPoint();
                            int index = this.this$1.list.locationToIndex(p);
                            Object value = this.this$1.list.getModel().getElementAt(index);
                            org.openide.nodes.Node node = Visualizer.findNode(value);
                            node.getPreferredAction().actionPerformed(new ActionEvent(node, 0, null));
                        }
                    }

                    private boolean isLink(MouseEvent event) {
                        Point p = event.getPoint();
                        int index = this.this$1.list.locationToIndex(p);
                        if (index == -1) {
                            return false;
                        }
                        Rectangle cellBounds = this.this$1.list.getCellBounds(index, index);
                        p.translate(-cellBounds.x, -cellBounds.y);
                        Object value = this.this$1.list.getModel().getElementAt(index);
                        renderer.getListCellRendererComponent(this.this$1.list, value, index, false, false);
                        return renderer.isLink(p);
                    }
                };
                this.list.addMouseMotionListener(adapter);
                this.list.addMouseListener(adapter);
            }

            protected void showSelection(int[] indexes) {
                super.showSelection(indexes);
                if (indexes != null && indexes.length > 0) {
                    this.list.ensureIndexIsVisible(indexes[0]);
                }
            }
        };
        this.rulePane.setHorizontalScrollBarPolicy(31);
        ExplorerManagerProviderPanel rulePanePanel = new ExplorerManagerProviderPanel();
        rulePanePanel.setLayout(new BorderLayout());
        rulePanePanel.add((Component)this.rulePane, "Center");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        JLabel rulePaneSummaryLabel = new JLabel();
        rulePaneSummaryLabel.setText(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.rulePaneHeader"));
        rulePaneSummaryLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        northPanel.add((Component)rulePaneSummaryLabel, "Center");
        CustomToolbar toolbar = new CustomToolbar();
        final JToggleButton createRuleToggleButton = new JToggleButton();
        this.editCSSRulesAction = new EditCSSRulesAction();
        createRuleToggleButton.setAction(this.editCSSRulesAction);
        Mnemonics.setLocalizedText((AbstractButton)createRuleToggleButton, null);
        createRuleToggleButton.setToolTipText((String)this.editCSSRulesAction.getValue("Name"));
        createRuleToggleButton.setFocusable(false);
        createRuleToggleButton.addActionListener(new ActionListener(){
            final /* synthetic */ CSSStylesSelectionPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                createRuleToggleButton.setSelected(false);
            }
        });
        toolbar.addButton(createRuleToggleButton);
        northPanel.add((Component)toolbar, "East");
        rulePanePanel.add((Component)northPanel, "North");
        rulePanePanel.setMinimumSize(new Dimension(0, 0));
        this.rulePaneManager = rulePanePanel.getExplorerManager();
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.rulePaneManager, (ActionMap)this.getActionMap());
        return rulePanePanel;
    }

    private void initSelectionOfOwningRule() {
        this.propertyPaneManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Lookup lookup;
                Rule rule;
                org.openide.nodes.Node[] selection;
                String propertyName = evt.getPropertyName();
                if ("selectedNodes".equals(propertyName) && (selection = CSSStylesSelectionPanel.this.propertyPaneManager.getSelectedNodes()).length == 1 && (rule = (Rule)(lookup = selection[0].getLookup()).lookup(Rule.class)) != null) {
                    this.selectRule(rule, CSSStylesSelectionPanel.this.rulePaneManager.getRootContext());
                }
            }

            private boolean selectRule(Rule rule, org.openide.nodes.Node root) {
                Lookup lookup = root.getLookup();
                Rule otherRule = (Rule)lookup.lookup(Rule.class);
                if (rule == otherRule) {
                    try {
                        CSSStylesSelectionPanel.this.rulePaneManager.setSelectedNodes(new org.openide.nodes.Node[]{root});
                    }
                    catch (PropertyVetoException ex) {
                        Logger.getLogger(CSSStylesSelectionPanel.class.getName()).log(Level.FINEST, null, ex);
                    }
                    return true;
                }
                for (org.openide.nodes.Node subNode : root.getChildren().getNodes()) {
                    if (!this.selectRule(rule, subNode)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void initMessagePanel() {
        this.messageLabel = new JLabel();
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setVerticalAlignment(0);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setBackground(new BeanTreeView().getViewport().getView().getBackground());
        this.messageLabel.setOpaque(true);
        this.messagePanel = new JPanel();
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.add((Component)this.messageLabel, "Center");
    }

    final void updateContent(WebKitPageModel pageModel, boolean keepSelection) {
        if (this.pageModel != null) {
            this.pageModel.removePropertyChangeListener(this.getListener());
        }
        this.pageModel = pageModel;
        if (this.pageModel != null) {
            this.pageModel.addPropertyChangeListener(this.getListener());
        }
        this.updateContentImpl(pageModel, keepSelection);
    }

    void updateContentImpl(final WebKitPageModel pageModel, final boolean keepSelection) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ CSSStylesSelectionPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.updateContentImpl(pageModel, keepSelection);
                }
            });
            return;
        }
        this.inspectedNode = null;
        if (pageModel == null) {
            this.setDummyRoots();
            this.editCSSRulesAction.setActiveNode(null);
        } else {
            List<org.openide.nodes.Node> selection = pageModel.getSelectedNodes();
            int selectionSize = 0;
            boolean containsUnkownNode = false;
            org.openide.nodes.Node knownNode = null;
            for (org.openide.nodes.Node node : selection) {
                Object webKitNode = node.getLookup().lookup(Node.class);
                if (webKitNode == null) {
                    containsUnkownNode = true;
                    continue;
                }
                knownNode = node;
                ++selectionSize;
            }
            if (selectionSize == 0) {
                TopComponent tc;
                this.setDummyRoots();
                String key = containsUnkownNode ? ((tc = WindowManager.getDefault().findTopComponent("DomTC")).isOpened() ? "CSSStylesSelectionPanel.selectInDOMTree" : "CSSStylesSelectionPanel.unknownElementSelected") : "CSSStylesSelectionPanel.noElementSelected";
                this.showLabel(key);
            } else if (selectionSize > 1) {
                this.setDummyRoots();
                this.showLabel("CSSStylesSelectionPanel.multipleElementsSelected");
            } else {
                org.openide.nodes.Node node;
                this.inspectedNode = knownNode;
                org.openide.nodes.Node selectedNode = knownNode;
                node = (Node)selectedNode.getLookup().lookup(Node.class);
                if (node.getNodeType() == 1) {
                    String name = selectedNode.getHtmlDisplayName();
                    if (name.startsWith("<html>")) {
                        name = name.substring(6);
                    }
                    String header = NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.propertySummaryHeader", (Object)name);
                    this.propertySummaryLabel.setText("<html><div>" + header + "</div>");
                    int width = this.propertySummaryLabel.getPreferredSize().width;
                    this.propertySummaryLabel.setText("<html><div width=\"" + width + "\">" + header + "</div>");
                    this.showLabel(null);
                    this.updatePseudoClassPanel(pageModel, (Node)node);
                    this.updateMatchedRules(pageModel, selectedNode, keepSelection);
                } else {
                    this.setDummyRoots();
                    this.showLabel("CSSStylesSelectionPanel.noElementSelected");
                }
            }
            this.editCSSRulesAction.setActiveNode((org.openide.nodes.Node)(selectionSize == 1 ? knownNode : null));
        }
        this.revalidate();
        this.repaint();
    }

    void updateMatchedRules(final WebKitPageModel pageModel, final org.openide.nodes.Node selectedNode, final boolean keepSelection) {
        if (EventQueue.isDispatchThread()) {
            RP.post(new Runnable(){
                final /* synthetic */ CSSStylesSelectionPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.updateMatchedRules(pageModel, selectedNode, keepSelection);
                }
            });
            return;
        }
        Node node = (Node)selectedNode.getLookup().lookup(Node.class);
        WebKitDebugging webKit = pageModel.getWebKit();
        CSS css = webKit.getCSS();
        CSS.PseudoClass[] pseudoClasses = pageModel.getPseudoClasses(node);
        css.forcePseudoState(node, pseudoClasses);
        MatchedStyles matchedStyles = css.getMatchedStyles(node, pseudoClasses, true, true);
        Map propertyInfos = css.getSupportedCSSProperties();
        if (matchedStyles != null) {
            Project project = pageModel.getProject();
            MatchedRulesNode rulePaneRoot = new MatchedRulesNode(project, selectedNode, matchedStyles);
            MatchedPropertiesNode propertyPaneRoot = new MatchedPropertiesNode(project, matchedStyles, propertyInfos);
            this.updateResourceCache((org.openide.nodes.Node)rulePaneRoot);
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ org.openide.nodes.Node val$rulePaneRoot;
                final /* synthetic */ org.openide.nodes.Node val$propertyPaneRoot;
                final /* synthetic */ boolean val$keepSelection;
                final /* synthetic */ CSSStylesSelectionPanel this$0;
                {
                    this.val$rulePaneRoot = node;
                    this.val$propertyPaneRoot = node2;
                    this.val$keepSelection = bl;
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    org.openide.nodes.Node[] selectedRules = this.this$0.rulePaneManager.getSelectedNodes();
                    org.openide.nodes.Node[] selectedProperties = this.this$0.propertyPaneManager.getSelectedNodes();
                    this.this$0.rulePaneManager.setRootContext(this.val$rulePaneRoot);
                    this.this$0.propertyPaneManager.setRootContext(this.val$propertyPaneRoot);
                    if (this.val$keepSelection) {
                        org.openide.nodes.Node[] nodes;
                        org.openide.nodes.Node newSelectedRuleNode;
                        org.openide.nodes.Node selectedRuleNode;
                        Rule selectedRule;
                        org.openide.nodes.Node selectedProperty;
                        Property property;
                        if (selectedProperties.length > 0 && (property = (Property)(selectedProperty = selectedProperties[0]).getLookup().lookup(Property.class)) != null) {
                            String propertyName = property.getName();
                            for (org.openide.nodes.Node candidate : this.val$propertyPaneRoot.getChildren().getNodes()) {
                                Property candProperty = (Property)candidate.getLookup().lookup(Property.class);
                                if (candProperty == null || !propertyName.equals(candProperty.getName())) continue;
                                try {
                                    this.this$0.propertyPaneManager.setSelectedNodes(new org.openide.nodes.Node[]{candidate});
                                }
                                catch (PropertyVetoException propertyVetoException) {}
                                break;
                            }
                        }
                        if (selectedRules.length > 0 && (selectedRule = (Rule)(selectedRuleNode = selectedRules[0]).getLookup().lookup(Rule.class)) != null && (newSelectedRuleNode = Utilities.findRule(this.val$rulePaneRoot, selectedRule)) != null) {
                            try {
                                this.this$0.rulePaneManager.setSelectedNodes(new org.openide.nodes.Node[]{newSelectedRuleNode});
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                        if ((nodes = this.this$0.rulePaneManager.getSelectedNodes()).length == 0) {
                            this.this$0.preselectRule();
                        }
                    } else {
                        this.this$0.preselectRule();
                    }
                }
            });
        }
    }

    void updateResourceCache(org.openide.nodes.Node parent) {
        Children children = parent.getChildren();
        for (org.openide.nodes.Node node : children.getNodes(true)) {
            Resource ruleOrigin = (Resource)node.getLookup().lookup(Resource.class);
            if (ruleOrigin == null) continue;
            this.resourceCache.put(ruleOrigin, ruleOrigin.toFileObject());
        }
    }

    void preselectRule() {
        org.openide.nodes.Node propertyPaneRoot = this.propertyPaneManager.getRootContext();
        org.openide.nodes.Node[] nodes = propertyPaneRoot.getChildren().getNodes();
        if (nodes.length == 0) {
            org.openide.nodes.Node rulePaneRoot = this.rulePaneManager.getRootContext();
            nodes = rulePaneRoot.getChildren().getNodes();
            if (nodes.length > 0) {
                try {
                    this.rulePaneManager.setSelectedNodes(new org.openide.nodes.Node[]{nodes[0]});
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else {
            try {
                this.propertyPaneManager.setSelectedNodes(new org.openide.nodes.Node[]{nodes[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void showLabel(String key) {
        if (key == null != (this.selectionView.getParent() != null)) {
            if (key == null) {
                this.remove(this.messagePanel);
                this.add(this.selectionView);
            } else {
                this.remove(this.selectionView);
                this.add(this.messagePanel);
            }
        }
        if (key != null) {
            String message = NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)key);
            this.messageLabel.setText(message);
        }
    }

    private void setDummyRoots() {
        AbstractNode rulePaneRoot = new AbstractNode(Children.LEAF);
        AbstractNode propertyPaneRoot = new AbstractNode(Children.LEAF);
        rulePaneRoot.setDisplayName(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"MatchedRulesNode.displayName"));
        propertyPaneRoot.setDisplayName(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"MatchedPropertiesNode.displayName"));
        this.rulePaneManager.setRootContext((org.openide.nodes.Node)rulePaneRoot);
        this.propertyPaneManager.setRootContext((org.openide.nodes.Node)propertyPaneRoot);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private synchronized Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    static class PropertyPaneView
    extends TreeTableView {
        PropertyPaneView() {
            this.setRootVisible(false);
            this.setSelectionMode(1);
            TreeCellRenderer renderer = this.tree.getCellRenderer();
            ((NodeRenderer)renderer).setShowIcons(false);
            this.hideTreeLines();
            if (Boolean.getBoolean("netbeans.plaf.dark.theme") || "Nimbus".equals(UIManager.getLookAndFeel().getID())) {
                this.treeTable.getParent().setBackground(new Color(this.treeTable.getBackground().getRGB()));
            } else {
                Color bgColor = UIManager.getColor("Label.background");
                this.treeTable.setBackground(bgColor);
                this.treeTable.getParent().setBackground(bgColor);
            }
            HtmlRenderer.Renderer defaultRenderer = HtmlRenderer.createRenderer();
            this.treeTable.setDefaultRenderer(Node.Property.class, new TableCellRenderer(){
                private final Border[] border = new Border[]{BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createEmptyBorder(1, 3, 0, 0)};
                final /* synthetic */ TableCellRenderer val$defaultRenderer;
                final /* synthetic */ PropertyPaneView this$0;
                {
                    this.val$defaultRenderer = tableCellRenderer;
                    this.this$0 = this$0;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component;
                    String toolTip = null;
                    boolean isColor = false;
                    if (value instanceof Node.Property) {
                        Node.Property property = (Node.Property)value;
                        toolTip = property.getShortDescription();
                        try {
                            value = property.getValue();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                        Object color = property.getValue("color");
                        boolean bl = isColor = color == Boolean.TRUE;
                    }
                    if ((component = this.val$defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                        JComponent jcomponent = (JComponent)component;
                        jcomponent.setBorder(this.border[column]);
                        jcomponent.setToolTipText(toolTip);
                    }
                    if (isColor && component instanceof JLabel) {
                        String colorCode = value.toString();
                        CssColor color = CssColor.getColor((String)colorCode);
                        if (color != null) {
                            colorCode = color.colorCode();
                        }
                        if (colorCode.startsWith("#") || color != null) {
                            JLabel label = (JLabel)component;
                            label.setIcon(WebUIUtils.createColorIcon((String)colorCode));
                        }
                    }
                    return component;
                }
            });
            this.treeTable.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        JLabel label = (JLabel)component;
                        label.setText("<html><b>" + label.getText() + "<b>");
                        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, column == 0 ? 17 : 1, 0, 0)));
                    }
                    return component;
                }
            });
        }

        private void hideTreeLines() {
            TreeUI treeUI = this.tree.getUI();
            if (treeUI instanceof BasicTreeUI) {
                try {
                    Field paintLines = BasicTreeUI.class.getDeclaredField("paintLines");
                    paintLines.setAccessible(true);
                    paintLines.setBoolean(treeUI, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    static class ExplorerManagerProviderPanel
    extends JPanel
    implements ExplorerManager.Provider,
    Lookup.Provider {
        private final ExplorerManager manager = new ExplorerManager();
        private final Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap());

        ExplorerManagerProviderPanel() {
        }

        public final ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public Lookup getLookup() {
            return this.lookup;
        }
    }

    class Listener
    implements PropertyChangeListener {
        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("selectedNodes".equals(propertyName)) {
                CSSStylesSelectionPanel.this.updateContentImpl(CSSStylesSelectionPanel.this.pageModel, false);
            }
        }
    }

    static class StylesRenderer
    extends DefaultListCellRenderer {
        private final JPanel renderer = new JPanel();
        private final JLabel matchedNodeLabel = new JLabel();
        private final JLabel selectorLabel = new JLabel();
        private final JLabel mediaLabel = new JLabel();
        private final JLabel ruleLocationLabel = new JLabel();
        private final JPanel ruleLocationPanel = new JPanel();
        private final ListCellRenderer htmlRenderer = HtmlRenderer.createRenderer();
        private final Map<Resource, FileObject> resourceCache;

        StylesRenderer(Map<Resource, FileObject> resourceCache) {
            this.resourceCache = resourceCache;
            this.ruleLocationPanel.setOpaque(false);
            this.ruleLocationPanel.setLayout(new BorderLayout());
            this.ruleLocationPanel.add((Component)this.ruleLocationLabel, "Before");
        }

        private void buildLayout() {
            GroupLayout layout = new GroupLayout(this.renderer);
            GroupLayout.Group hGroup = layout.createSequentialGroup().addComponent(this.selectorLabel, 1, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.matchedNodeLabel, 1, 1, Short.MAX_VALUE).addComponent(this.ruleLocationPanel, 1, 1, Short.MAX_VALUE));
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectorLabel).addGroup(layout.createSequentialGroup().addComponent(this.matchedNodeLabel).addComponent(this.ruleLocationPanel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE);
            hGroup = layout.createParallelGroup().addComponent(this.mediaLabel, 1, 1, Short.MAX_VALUE).addGroup(hGroup);
            vGroup = layout.createSequentialGroup().addComponent(this.mediaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vGroup);
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            this.renderer.setLayout(layout);
            Color borderColor = UIManager.getColor("Label.background");
            this.renderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, borderColor), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent component = (JComponent)super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
            JLabel htmlLabel = (JLabel)this.htmlRenderer.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
            Color bgColor = this.color(htmlLabel, false);
            if (bgColor == null) {
                bgColor = component.getBackground();
            }
            this.renderer.setOpaque(isSelected);
            this.renderer.setBackground(bgColor);
            this.renderer.setBorder(component.getBorder());
            Color foreground = this.color(htmlLabel, true);
            if (foreground == null) {
                foreground = component.getForeground();
            }
            this.matchedNodeLabel.setForeground(foreground);
            this.selectorLabel.setForeground(foreground);
            this.mediaLabel.setForeground(foreground);
            org.openide.nodes.Node node = Visualizer.findNode((Object)value);
            Rule rule = (Rule)node.getLookup().lookup(Rule.class);
            if (rule != null) {
                String matchedNode = node.getDisplayName();
                this.matchedNodeLabel.setText("<html>" + matchedNode);
                String ruleLocation = null;
                RuleInfo ruleInfo = (RuleInfo)node.getLookup().lookup(RuleInfo.class);
                if (ruleInfo != null && ruleInfo.getMetaSourceFile() != null && ruleInfo.getMetaSourceLine() != -1) {
                    ruleLocation = ruleInfo.getMetaSourceFile();
                    int slashIndex = Math.max(ruleLocation.lastIndexOf(47), ruleLocation.lastIndexOf(92));
                    ruleLocation = ruleLocation.substring(slashIndex + 1);
                    ruleLocation = ruleLocation + ":" + ruleInfo.getMetaSourceLine();
                } else {
                    FileObject fob;
                    Resource ruleOrigin = (Resource)node.getLookup().lookup(Resource.class);
                    if (ruleOrigin != null && (ruleLocation = (fob = this.resourceCache.get(ruleOrigin)) == null ? rule.getSourceURL() : fob.getNameExt()) != null) {
                        if (ruleLocation.isEmpty()) {
                            ruleLocation = Bundle.CSSStylesSelectionPanel_generatedStylesheet();
                        }
                        int sourceLine = rule.getSourceLine() + 1;
                        ruleLocation = ruleLocation + ":" + sourceLine;
                    }
                }
                this.ruleLocationLabel.setVisible(ruleLocation != null);
                if (ruleLocation != null) {
                    ruleLocation = "<html><u>" + ruleLocation;
                }
                this.ruleLocationLabel.setText(ruleLocation);
                this.ruleLocationPanel.doLayout();
                String selector = rule.getSelector();
                this.selectorLabel.setText("<html>" + selector);
                String mediaQuery = null;
                for (Media media : rule.getMedia()) {
                    mediaQuery = media.getText();
                }
                this.mediaLabel.setText(mediaQuery);
                this.mediaLabel.setVisible(mediaQuery != null);
                Color fg = isSelected ? foreground : (UIManager.getLookAndFeel().getID().equals("GTK") ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
                this.ruleLocationLabel.setForeground(fg);
                this.mediaLabel.setForeground(fg);
                this.mediaLabel.setEnabled(isSelected);
            }
            String toolTip = node.getShortDescription();
            this.renderer.setToolTipText(toolTip);
            int width = list.getWidth() - list.getInsets().left - list.getInsets().right;
            this.renderer.setSize(width, 1);
            this.buildLayout();
            this.renderer.doLayout();
            this.resizeViewToMatchTheCurrentSize(this.matchedNodeLabel);
            this.resizeViewToMatchTheCurrentSize(this.selectorLabel);
            this.buildLayout();
            this.renderer.doLayout();
            return this.renderer;
        }

        private void resizeViewToMatchTheCurrentSize(JLabel label) {
            Object view = label.getClientProperty("html");
            if (view instanceof View) {
                ((View)view).setSize(label.getWidth(), label.getHeight());
            }
        }

        private Color color(JLabel label, boolean foreground) {
            Color color = null;
            LabelUI htmlUI = label.getUI();
            try {
                String methodName = foreground ? "getForegroundFor" : "getBackgroundFor";
                Method method = htmlUI.getClass().getDeclaredMethod(methodName, this.htmlRenderer.getClass());
                method.setAccessible(true);
                Object result = method.invoke(null, this.htmlRenderer);
                if (result instanceof Color) {
                    color = (Color)result;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return color;
        }

        boolean isLink(Point point) {
            boolean link = false;
            Rectangle bounds = this.ruleLocationPanel.getBounds();
            if (bounds.contains(point)) {
                point.translate(-bounds.x, -bounds.y);
                bounds = this.ruleLocationLabel.getBounds();
                link = bounds.contains(point);
            }
            return link;
        }
    }
}

