/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.sourcemap.Mapping;
import org.netbeans.modules.web.common.sourcemap.SourceMap;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedRulesNode;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.Style;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.openide.filesystems.FileObject;

public class RuleInfo {
    private final Set<String> overridenProperties = new HashSet<String>();
    private boolean inherited;
    private String metaSourceFile;
    private int metaSourceLine = -1;

    void markAsOverriden(String propertyName) {
        this.overridenProperties.add(propertyName);
    }

    public boolean isOverriden(String propertyName) {
        return this.overridenProperties.contains(propertyName);
    }

    void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    private void setMetaSourceFile(String metaSourceFile) {
        this.metaSourceFile = metaSourceFile;
    }

    public String getMetaSourceFile() {
        return this.metaSourceFile;
    }

    private void setMetaSourceLine(int metaSourceLine) {
        this.metaSourceLine = metaSourceLine;
    }

    public int getMetaSourceLine() {
        return this.metaSourceLine;
    }

    void fillMetaSourceInfo(Rule rule, Project project) {
        StyleSheetBody body = rule.getParentStyleSheet();
        if (body != null) {
            List rules;
            int index;
            block10: {
                FileObject folder;
                FileObject sourceMapFob;
                FileObject cssFile;
                String sourceMapPath;
                String styleSheetText = body.getText();
                if (styleSheetText != null && (sourceMapPath = CSSUtils.sourceMapPath(styleSheetText)) != null && (cssFile = new Resource(project, rule.getSourceURL()).toFileObject()) != null && (sourceMapFob = (folder = cssFile.getParent()).getFileObject(sourceMapPath)) != null) {
                    try {
                        String sourceMapText = sourceMapFob.asText();
                        SourceMap sourceMap = SourceMap.parse((String)sourceMapText);
                        Mapping mapping = sourceMap.findMapping(rule.getSourceLine());
                        if (mapping == null) break block10;
                        int sourceIndex = mapping.getSourceIndex();
                        String sourcePath = sourceMap.getSourcePath(sourceIndex);
                        folder = sourceMapFob.getParent();
                        FileObject source = folder.getFileObject(sourcePath);
                        if (source == null) {
                            Logger.getLogger(RuleInfo.class.getName()).log(Level.INFO, "Unable to find the file {0} relative to the source map {1}!", new Object[]{sourcePath, sourceMapFob.getPath()});
                            break block10;
                        }
                        String sourceURL = source.toURL().toExternalForm();
                        String sourceFile = Utilities.relativeResourceName(sourceURL, project);
                        this.setMetaSourceFile(sourceFile);
                        this.setMetaSourceLine(mapping.getOriginalLine() + 1);
                        return;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(RuleInfo.class.getName()).log(Level.INFO, null, ex);
                    }
                }
            }
            if ((index = (rules = body.getRules()).indexOf(rule)) != -1) {
                Media media;
                String mediaText;
                Rule previousRule;
                List medias;
                while (index > 0 && !(medias = (previousRule = (Rule)rules.get(--index)).getMedia()).isEmpty() && "-sass-debug-info".equals(mediaText = (media = (Media)medias.get(0)).getText())) {
                    String prefix;
                    Property property;
                    String lineTxt;
                    int prefixIndex;
                    String selector = previousRule.getSelector();
                    if ("filename".equals(selector)) {
                        Property property2 = RuleInfo.property(previousRule, "font-family");
                        String file = property2 == null ? null : this.propertyValueHack(property2);
                        this.setMetaSourceFile(file);
                        continue;
                    }
                    if (!"line".equals(selector) || (prefixIndex = (lineTxt = (property = RuleInfo.property(previousRule, "font-family")).getValue()).indexOf(prefix = "0003")) == -1) continue;
                    lineTxt = lineTxt.substring(prefixIndex + prefix.length());
                    try {
                        int lineNo = Integer.parseInt(lineTxt);
                        this.setMetaSourceLine(lineNo);
                    }
                    catch (NumberFormatException nfex) {
                        Logger.getLogger(MatchedRulesNode.class.getName()).log(Level.INFO, null, nfex);
                    }
                }
            }
        }
    }

    private static Property property(Rule rule, String propertyName) {
        Property result = null;
        Style style = rule.getStyle();
        for (Property property : style.getProperties()) {
            String name = property.getName();
            if (!propertyName.equals(name)) continue;
            result = property;
            break;
        }
        return result;
    }

    private String propertyValueHack(Property property) {
        String text = property.getText();
        int index = text.indexOf(":");
        text = text.substring(index + 1).trim();
        StringBuilder sb = new StringBuilder();
        boolean slash = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (slash && c != ':' && c != '/' && c != '.') {
                sb.append('\\');
            }
            boolean bl = slash = !slash && c == '\\';
            if (slash) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

