/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.refactoring;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.htmlui.HTMLDialog;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.refactoring.Bundle;
import org.netbeans.modules.java.lsp.server.refactoring.CodeRefactoring;
import org.netbeans.modules.java.lsp.server.refactoring.ElementUI;
import org.netbeans.modules.java.lsp.server.refactoring.MoveElementUI;
import org.netbeans.modules.java.lsp.server.refactoring.NamedPath;
import org.netbeans.modules.java.lsp.server.refactoring.Pages;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class MoveRefactoring
extends CodeRefactoring {
    private static final String MOVE_REFACTORING_KIND = "refactor.move";
    private static final String MOVE_REFACTORING_COMMAND = "nbls.java.refactor.move";
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = MoveRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(offset);
        if (ts.moveNext() && ts.token().id() != JavaTokenId.WHITESPACE && ts.offset() == offset) {
            ++offset;
        }
        String uri = Utils.toUri(info.getFileObject());
        Element element = MoveRefactoring.elementForOffset((CompilationInfo)info, offset);
        if (element != null) {
            return Collections.singletonList(this.createCodeAction(client, Bundle.DN_Move(), MOVE_REFACTORING_KIND, null, MOVE_REFACTORING_COMMAND, uri, new CodeActionsProvider.ElementData(element)));
        }
        return Collections.singletonList(this.createCodeAction(client, Bundle.DN_Move(), MOVE_REFACTORING_KIND, null, MOVE_REFACTORING_COMMAND, uri));
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(MOVE_REFACTORING_COMMAND);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        block4: {
            try {
                if (arguments.size() > 0) {
                    String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
                    FileObject file = Utils.fromUri(uri);
                    JavaSource js = JavaSource.forFileObject((FileObject)file);
                    if (js != null) {
                        return CompletableFuture.supplyAsync(() -> {
                            try {
                                js.runUserActionTask(ci -> {
                                    ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    if (arguments.size() > 1) {
                                        Element element = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(arguments.get(1)), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)ci);
                                        if (element != null) {
                                            if (element.getKind().isClass() || element.getKind().isInterface()) {
                                                Pages.showMoveClassUI(ci, client, file, element);
                                            } else {
                                                Pages.showMoveMembersUI(ci, client, file, element);
                                            }
                                        }
                                    } else {
                                        Pages.showMoveClassUI(ci, client, file, null);
                                    }
                                }, true);
                                return null;
                            }
                            catch (IOException ex) {
                                throw new IllegalStateException(ex);
                            }
                        }, (Executor)RequestProcessor.getDefault());
                    }
                    break block4;
                }
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            catch (JsonSyntaxException | IllegalArgumentException | MalformedURLException ex) {
                client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    static HTMLDialog.OnSubmit showMoveClassUI(CompilationController ci, NbCodeLanguageClient client, FileObject file, Element element) {
        MoveElementUI model = new MoveElementUI();
        model.withMoveClass(true).withFrom(file.getName()).assignData(client, file, element != null ? TreePathHandle.create((Element)element, (CompilationInfo)ci) : null);
        model.applyBindings();
        return id -> {
            if ("accept".equals(id)) {
                model.doRefactoring();
            }
            return true;
        };
    }

    static HTMLDialog.OnSubmit showMoveMembersUI(CompilationController ci, NbCodeLanguageClient client, FileObject file, Element element) {
        ElementUtilities eu = ci.getElementUtilities();
        Element enclosingElement = element.getEnclosingElement();
        String parentName = MoveRefactoring.createLabel((CompilationInfo)ci, enclosingElement);
        ElementUI[] members = (ElementUI[])enclosingElement.getEnclosedElements().stream().filter(memberElement -> (memberElement.getKind().isField() || memberElement.getKind() == ElementKind.METHOD) && !eu.isSynthetic(memberElement)).map(memberElement -> {
            String label = MoveRefactoring.createLabel((CompilationInfo)ci, memberElement);
            CodeActionsProvider.ElementData data = new CodeActionsProvider.ElementData((Element)memberElement);
            ElementUI memberElementUI = new ElementUI(memberElement == element, label, memberElement.getKind().name(), data.getSignature());
            return memberElementUI;
        }).toArray(ElementUI[]::new);
        MoveElementUI model = new MoveElementUI();
        model.withMoveClass(false).withFrom(parentName).withMembers(members).withKeepMethodSelected(false).withDeprecateMethodSelected(true).assignData(client, file, TreePathHandle.create((Element)element, (CompilationInfo)ci));
        model.applyBindings();
        return id -> {
            if ("accept".equals(id)) {
                model.doRefactoring();
            }
            return true;
        };
    }

    private static Element elementForOffset(CompilationInfo info, int offset) throws RuntimeException {
        List topLevelElements = info.getTopLevelElements();
        Trees trees = info.getTrees();
        SourcePositions sourcePositions = trees.getSourcePositions();
        CompilationUnitTree compilationUnit = info.getCompilationUnit();
        for (TypeElement typeElement : topLevelElements) {
            ClassTree topLevelClass = trees.getTree(typeElement);
            long startPosition = sourcePositions.getStartPosition(compilationUnit, topLevelClass);
            long endPosition = sourcePositions.getEndPosition(compilationUnit, topLevelClass);
            if ((long)offset <= startPosition || (long)offset >= endPosition) continue;
            for (Element element : typeElement.getEnclosedElements()) {
                Tree member = trees.getTree(element);
                long startMember = sourcePositions.getStartPosition(compilationUnit, member);
                long endMember = sourcePositions.getEndPosition(compilationUnit, member);
                if ((long)offset <= startMember || (long)offset >= endMember) continue;
                return element;
            }
            return topLevelElements.size() > 1 ? typeElement : null;
        }
        return null;
    }

    public static enum JavaDoc {
        ASIS("As is"),
        UPDATE("Update");

        final String humanName;

        private JavaDoc(String humanName) {
            this.humanName = humanName;
        }

        public String toString() {
            return this.humanName;
        }
    }

    public static enum Visibility {
        ESCALATE("Escalate"),
        ASIS("As is"),
        PUBLIC("Public"),
        PROTECTED("Protected"),
        PACKAGE_PRIVATE("Package private"),
        PRIVATE("Private");

        final String humanName;

        private Visibility(String humanName) {
            this.humanName = humanName;
        }

        public String toString() {
            return this.humanName;
        }
    }

    static final class NamedPathControl {
        NamedPathControl() {
        }
    }

    static final class ElementControl {
        ElementControl() {
        }
    }

    static final class MoveElementControl {
        private NbCodeLanguageClient client;
        private FileObject file;
        private TreePathHandle handle;

        MoveElementControl() {
        }

        void assignData(MoveElementUI ui, NbCodeLanguageClient client, FileObject file, TreePathHandle handle) {
            this.client = client;
            this.file = file;
            this.handle = handle;
        }

        static List<NamedPath> availableProjects() {
            Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
            ArrayList<NamedPath> projectNames = new ArrayList<NamedPath>(openProjects.length);
            for (int i = 0; i < openProjects.length; ++i) {
                projectNames.add(new NamedPath(ProjectUtils.getInformation((Project)openProjects[i]).getDisplayName(), Utils.toUri(openProjects[i].getProjectDirectory())));
            }
            return projectNames;
        }

        static List<NamedPath> availableRoots(NamedPath selectedProject) {
            Project project = MoveElementControl.getSelectedProject(selectedProject);
            if (project != null) {
                Sources sources = ProjectUtils.getSources((Project)project);
                SourceGroup[] groups = sources.getSourceGroups("java");
                ArrayList<NamedPath> projectRoots = new ArrayList<NamedPath>(groups.length);
                for (int i = 0; i < groups.length; ++i) {
                    projectRoots.add(new NamedPath(groups[i].getDisplayName(), Utils.toUri(groups[i].getRootFolder())));
                }
                return projectRoots;
            }
            return Collections.emptyList();
        }

        static List<String> availablePackages(boolean moveClass, NamedPath selectedRoot) {
            FileObject rootFolder = MoveElementControl.getSelectedRoot(selectedRoot);
            if (rootFolder != null) {
                List<Object> packages;
                if (moveClass) {
                    packages = new ArrayList<String>();
                    packages.add(Bundle.DN_DefaultPackage());
                    Enumeration children = rootFolder.getChildren(true);
                    while (children.hasMoreElements()) {
                        FileObject child = (FileObject)children.nextElement();
                        if (!child.isFolder()) continue;
                        packages.add(FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)child).replace('/', '.'));
                    }
                } else {
                    packages = ClasspathInfo.create((FileObject)rootFolder).getClassIndex().getPackageNames("", false, EnumSet.of(ClassIndex.SearchScope.SOURCE)).stream().collect(Collectors.toList());
                }
                packages.sort((s1, s2) -> s1.compareTo((String)s2));
                return packages;
            }
            return Collections.emptyList();
        }

        static List<ElementUI> availableClasses(boolean moveClass, NamedPath selectedRoot, String selectedPackage) {
            FileObject rootFolder = MoveElementControl.getSelectedRoot(selectedRoot);
            if (rootFolder != null && selectedPackage != null) {
                FileObject fo = rootFolder.getFileObject(selectedPackage.replace('.', '/'));
                ClassPath sourcePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                ClasspathInfo info = ClasspathInfo.create((ClassPath)EMPTY_PATH, (ClassPath)EMPTY_PATH, (ClassPath)sourcePath);
                HashSet<1> searchScopeType = new HashSet<1>(1);
                final Set<String> packageSet = Collections.singleton(selectedPackage);
                searchScopeType.add(new ClassIndex.SearchScopeType(){

                    public Set<? extends String> getPackages() {
                        return packageSet;
                    }

                    public boolean isSources() {
                        return true;
                    }

                    public boolean isDependencies() {
                        return false;
                    }
                });
                ArrayList<ElementUI> ret = new ArrayList<ElementUI>();
                if (moveClass) {
                    ret.add(new ElementUI(false, Bundle.DN_CreateNewClass(), null, new String[0]));
                }
                for (ElementHandle eh : info.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, searchScopeType)) {
                    CodeActionsProvider.ElementData data = new CodeActionsProvider.ElementData((ElementHandle<? extends Element>)eh);
                    String shortName = eh.getQualifiedName().substring(selectedPackage.length() + 1);
                    int idx = shortName.indexOf(46);
                    if (fo.getFileObject(idx < 0 ? shortName : shortName.substring(0, idx), "java") == null) continue;
                    ret.add(new ElementUI(false, shortName, data.getKind(), data.getSignature()));
                }
                ret.sort((e1, e2) -> e1.getLabel().compareTo(e2.getLabel()));
                return ret;
            }
            return Collections.emptyList();
        }

        static List<Visibility> availableVisibilities() {
            return Arrays.asList(Visibility.values());
        }

        static List<JavaDoc> availableJavaDoc() {
            return Arrays.asList(JavaDoc.values());
        }

        void doRefactoring(MoveElementUI ui) {
            try {
                org.netbeans.modules.refactoring.api.MoveRefactoring refactoring;
                if (this.handle == null) {
                    refactoring = new org.netbeans.modules.refactoring.api.MoveRefactoring(Lookups.fixed((Object[])new Object[]{this.file}));
                    refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{this.file}));
                } else {
                    InstanceContent ic = new InstanceContent();
                    refactoring = new org.netbeans.modules.refactoring.api.MoveRefactoring((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
                    List<TreePathHandle> selectedElements = ui.getMembers().stream().filter(member -> member.isSelected()).map(selectedMember -> {
                        ElementHandle memberHandle = ElementHandleAccessor.getInstance().create(ElementKind.valueOf(selectedMember.getKind()), selectedMember.getSignature().toArray(new String[selectedMember.getSignature().size()]));
                        return TreePathHandle.from((ElementHandle)memberHandle, (ClasspathInfo)ClasspathInfo.create((FileObject)this.file));
                    }).collect(Collectors.toList());
                    ic.set(selectedElements, null);
                    if (this.handle.getKind() == Tree.Kind.CLASS) {
                        refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{this.handle.getFileObject()}));
                    } else {
                        JavaMoveMembersProperties properties = new JavaMoveMembersProperties(selectedElements.toArray(new TreePathHandle[0]));
                        properties.setVisibility(JavaMoveMembersProperties.Visibility.valueOf((String)ui.getSelectedVisibility().name()));
                        properties.setDelegate(ui.isKeepMethodSelected());
                        properties.setUpdateJavaDoc(ui.getSelectedJavaDoc() == JavaDoc.UPDATE);
                        properties.setAddDeprecated(ui.isDeprecateMethodSelected());
                        refactoring.getContext().add((Object)properties);
                    }
                }
                ElementUI selectedClass = ui.getSelectedClass();
                if (selectedClass != null) {
                    if (selectedClass.getKind() != null && selectedClass.getSignature() != null) {
                        ElementHandle eh = ElementHandleAccessor.getInstance().create(ElementKind.valueOf(selectedClass.getKind()), selectedClass.getSignature().toArray(new String[selectedClass.getSignature().size()]));
                        refactoring.setTarget(Lookups.singleton((Object)TreePathHandle.from((ElementHandle)eh, (ClasspathInfo)ClasspathInfo.create((FileObject)this.file))));
                    } else {
                        FileObject rootFolder = MoveElementControl.getSelectedRoot(ui.getSelectedRoot());
                        if (rootFolder != null && ui.getSelectedPackage() != null) {
                            refactoring.setTarget(Lookups.singleton((Object)rootFolder.getFileObject(ui.getSelectedPackage().replace('.', '/')).toURL()));
                        } else {
                            refactoring.setTarget(Lookup.EMPTY);
                        }
                    }
                } else {
                    refactoring.setTarget(Lookup.EMPTY);
                }
                this.client.applyEdit(new ApplyWorkspaceEditParams(CodeRefactoring.perform((AbstractRefactoring)refactoring, "Move")));
            }
            catch (Exception ex) {
                if (this.client == null) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.SEVERE));
                }
                this.client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }

        private static Project getSelectedProject(NamedPath selectedProject) {
            if (selectedProject == null) {
                return null;
            }
            try {
                String path = selectedProject.getPath();
                return path != null ? FileOwnerQuery.getOwner((FileObject)Utils.fromUri(path)) : null;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        private static FileObject getSelectedRoot(NamedPath selectedRoot) {
            if (selectedRoot == null) {
                return null;
            }
            try {
                String path = selectedRoot.getPath();
                return path != null ? Utils.fromUri(path) : null;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
    }
}

