/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class PropertyGetCommand
extends SvnCommand {
    private final File file;
    private final SVNUrl url;
    private final SVNRevision rev;
    private final SVNRevision peg;
    private final String name;
    private final GetType type;
    private byte[] bytes;

    public PropertyGetCommand(File file, String name) {
        this.file = file;
        this.name = name;
        this.url = null;
        this.rev = null;
        this.peg = null;
        this.type = GetType.file;
    }

    public PropertyGetCommand(SVNUrl url, SVNRevision rev, SVNRevision peg, String name) {
        this.url = url;
        this.name = name;
        this.rev = rev;
        this.peg = peg;
        this.file = null;
        this.type = GetType.url;
    }

    public byte[] getOutput() {
        return this.bytes == null ? new byte[]{} : this.bytes;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    public List<String> getCmdError() {
        return null;
    }

    @Override
    public void output(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    protected int getCommand() {
        return 20;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("propget");
        arguments.add("--strict");
        arguments.add(this.name);
        switch (this.type.ordinal()) {
            case 1: {
                arguments.add(this.file);
                break;
            }
            case 0: {
                arguments.add(this.rev);
                arguments.add(this.url, this.peg);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal gettype: " + (Object)((Object)this.type));
            }
        }
    }

    private static enum GetType {
        url,
        file;

    }
}

